/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.FieldModelBuilder;
import org.bson.codecs.pojo.annotations.Discriminator;
import org.bson.codecs.pojo.annotations.Id;
import org.bson.codecs.pojo.annotations.Property;

final class ConventionAnnotationImpl
implements Convention {
    ConventionAnnotationImpl() {
    }

    @Override
    public void apply(ClassModelBuilder<?> classModelBuilder) {
        for (Annotation annotation : classModelBuilder.getAnnotations()) {
            this.processClassAnnotation(classModelBuilder, annotation);
        }
        for (FieldModelBuilder fieldModelBuilder : classModelBuilder.getFields()) {
            for (Annotation annotation : fieldModelBuilder.getAnnotations()) {
                this.processFieldAnnotation(classModelBuilder, fieldModelBuilder, annotation);
            }
        }
    }

    void processClassAnnotation(ClassModelBuilder<?> classModelBuilder, Annotation annotation) {
        if (annotation instanceof Discriminator) {
            String name;
            Discriminator discriminator = (Discriminator)annotation;
            String key = discriminator.key();
            if (!key.equals("")) {
                classModelBuilder.discriminatorKey(key);
            }
            if (!(name = discriminator.value()).equals("")) {
                classModelBuilder.discriminator(name);
            }
            classModelBuilder.enableDiscriminator(true);
        }
    }

    void processFieldAnnotation(ClassModelBuilder<?> classModelBuilder, FieldModelBuilder<?> fieldModelBuilder, Annotation annotation) {
        if (annotation instanceof Property) {
            Property property = (Property)annotation;
            if (!"".equals(property.name())) {
                fieldModelBuilder.documentFieldName(property.name());
            }
            fieldModelBuilder.discriminatorEnabled(property.useDiscriminator());
        } else if (annotation instanceof Id) {
            classModelBuilder.idField(fieldModelBuilder.getFieldName());
        }
    }
}

