/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.FieldModel;
import org.bson.codecs.pojo.FieldModelBuilder;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.PojoBuilderHelper;
import org.bson.codecs.pojo.TypeParameterMap;

public class ClassModelBuilder<T> {
    private static final String ID_FIELD_NAME = "_id";
    private final List<FieldModelBuilder<?>> fields = new ArrayList();
    private InstanceCreatorFactory<T> instanceCreatorFactory;
    private Class<T> type;
    private Map<String, TypeParameterMap> fieldNameToTypeParameterMap = Collections.emptyMap();
    private List<Convention> conventions = Conventions.DEFAULT_CONVENTIONS;
    private List<Annotation> annotations = Collections.emptyList();
    private boolean discriminatorEnabled;
    private String discriminator;
    private String discriminatorKey;
    private String idField;

    ClassModelBuilder(Class<T> type) {
        PojoBuilderHelper.configureClassModelBuilder(this, Assertions.notNull("type", type));
    }

    public ClassModelBuilder<T> instanceCreatorFactory(InstanceCreatorFactory<T> instanceCreatorFactory) {
        this.instanceCreatorFactory = Assertions.notNull("instanceCreatorFactory", instanceCreatorFactory);
        return this;
    }

    public InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    public ClassModelBuilder<T> type(Class<T> type) {
        this.type = Assertions.notNull("type", type);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public ClassModelBuilder<T> conventions(List<Convention> conventions) {
        this.conventions = Assertions.notNull("conventions", conventions);
        return this;
    }

    public List<Convention> getConventions() {
        return this.conventions;
    }

    public ClassModelBuilder<T> annotations(List<Annotation> annotations) {
        this.annotations = Assertions.notNull("annotations", annotations);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public ClassModelBuilder<T> discriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public ClassModelBuilder<T> discriminatorKey(String discriminatorKey) {
        this.discriminatorKey = discriminatorKey;
        return this;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public ClassModelBuilder<T> enableDiscriminator(boolean discriminatorEnabled) {
        this.discriminatorEnabled = discriminatorEnabled;
        return this;
    }

    public Boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public ClassModelBuilder<T> idField(String idField) {
        this.idField = Assertions.notNull("idField", idField);
        return this;
    }

    public String getIdField() {
        return this.idField;
    }

    public boolean removeField(String name) {
        return this.fields.remove(this.getField(Assertions.notNull("name", name)));
    }

    public FieldModelBuilder<?> getField(String name) {
        Assertions.notNull("name", name);
        for (FieldModelBuilder<?> fieldModelBuilder : this.fields) {
            if (!fieldModelBuilder.getFieldName().equals(name)) continue;
            return fieldModelBuilder;
        }
        return null;
    }

    public List<FieldModelBuilder<?>> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public ClassModel<T> build() {
        ArrayList fieldModels = new ArrayList();
        FieldModel idFieldModel = null;
        PojoBuilderHelper.stateNotNull("type", this.type);
        for (Convention convention : this.conventions) {
            convention.apply(this);
        }
        PojoBuilderHelper.stateNotNull("instanceCreatorFactory", this.instanceCreatorFactory);
        if (this.discriminatorEnabled) {
            PojoBuilderHelper.stateNotNull("discriminatorKey", this.discriminatorKey);
            PojoBuilderHelper.stateNotNull("discriminator", this.discriminator);
        }
        for (FieldModelBuilder fieldModelBuilder : this.fields) {
            boolean isIdField = fieldModelBuilder.getFieldName().equals(this.idField);
            if (isIdField) {
                fieldModelBuilder.documentFieldName(ID_FIELD_NAME);
            }
            FieldModel model = fieldModelBuilder.build();
            fieldModels.add(model);
            if (!isIdField) continue;
            idFieldModel = model;
        }
        this.validateFieldModels(fieldModels);
        return new ClassModel<T>(this.type, this.fieldNameToTypeParameterMap, this.instanceCreatorFactory, this.discriminatorEnabled, this.discriminatorKey, this.discriminator, idFieldModel, Collections.unmodifiableList(fieldModels));
    }

    public String toString() {
        return String.format("ClassModelBuilder{type=%s}", this.type);
    }

    Map<String, TypeParameterMap> getFieldNameToTypeParameterMap() {
        return this.fieldNameToTypeParameterMap;
    }

    ClassModelBuilder<T> fieldNameToTypeParameterMap(Map<String, TypeParameterMap> fieldNameToTypeParameterMap) {
        this.fieldNameToTypeParameterMap = Collections.unmodifiableMap(new HashMap<String, TypeParameterMap>(fieldNameToTypeParameterMap));
        return this;
    }

    ClassModelBuilder<T> addField(FieldModelBuilder<?> fieldModelBuilder) {
        this.fields.add(Assertions.notNull("fieldModelBuilder", fieldModelBuilder));
        return this;
    }

    private void validateFieldModels(List<FieldModel<?>> fieldModels) {
        HashMap<String, Integer> fieldNameMap = new HashMap<String, Integer>();
        HashMap<String, Integer> fieldDocumentNameMap = new HashMap<String, Integer>();
        String duplicateFieldName = null;
        String duplicateDocumentFieldName = null;
        for (FieldModel<?> fieldModel : fieldModels) {
            String fieldName = fieldModel.getFieldName();
            if (fieldNameMap.containsKey(fieldName)) {
                duplicateFieldName = fieldName;
                break;
            }
            fieldNameMap.put(fieldName, 1);
            String documentFieldName = fieldModel.getDocumentFieldName();
            if (fieldDocumentNameMap.containsKey(documentFieldName)) {
                duplicateDocumentFieldName = documentFieldName;
                break;
            }
            fieldDocumentNameMap.put(documentFieldName, 1);
        }
        if (this.idField != null && !fieldNameMap.containsKey(this.idField)) {
            throw new IllegalStateException(String.format("Invalid id field, field named field '%s' can not be found.", this.idField));
        }
        if (duplicateFieldName != null) {
            throw new IllegalStateException(String.format("Duplicate field named '%s' found.", duplicateFieldName));
        }
        if (duplicateDocumentFieldName != null) {
            throw new IllegalStateException(String.format("Duplicate document field named '%s' found.", duplicateDocumentFieldName));
        }
    }
}

