/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

final class SingleCodecRegistry<T>
implements CodecRegistry {
    private final Codec<T> codec;

    SingleCodecRegistry(Codec<T> codec) {
        this.codec = Assertions.notNull("codec", codec);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz) {
        if (this.codec.getEncoderClass() == clazz) {
            return this.codec;
        }
        throw new CodecConfigurationException(String.format("Can't find a codec for %s.", clazz));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleCodecRegistry that = (SingleCodecRegistry)o;
        return this.codec.equals(that.codec);
    }

    public int hashCode() {
        return this.codec.hashCode();
    }
}

