/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.simple;

import java.util.List;
import org.monarchinitiative.sgenes.model.Gene;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.sgenes.model.TranscriptEvidence;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.sgenes.model.TranscriptMetadata;
import org.monarchinitiative.svart.Contig;
import org.monarchinitiative.svart.CoordinateSystem;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;
import org.monarchinitiative.svart.Strand;
import org.monarchinitiative.svart.assembly.GenomicAssemblies;
import org.monarchinitiative.svart.assembly.GenomicAssembly;

public class Genes {
    private static final GenomicAssembly ASSEMBLY = GenomicAssemblies.GRCh38p13();

    private Genes() {
    }

    public static Gene surf2() {
        Contig contig = ASSEMBLY.contigByName("chr9");
        Transcript surf2_201 = Genes.surf2_201(contig);
        List<Transcript> transcripts = List.of(surf2_201);
        GenomicRegion location = GenomicRegion.of((Contig)contig, (Strand)Strand.POSITIVE, (CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356549, (int)133361158);
        GeneIdentifier id = GeneIdentifier.of((String)"ENSG00000148291.10", (String)"SURF2", (String)"HGNC:11475", (String)"NCBIGene:6835");
        return Gene.of((GeneIdentifier)id, (GenomicRegion)location, transcripts);
    }

    public static Transcript surf2_201(Contig contig) {
        TranscriptIdentifier txId = TranscriptIdentifier.of((String)"ENST00000371964.5", (String)"SURF2-201", (String)"CCDS6967.1");
        GenomicRegion location = GenomicRegion.of((Contig)contig, (Strand)Strand.POSITIVE, (CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356549, (int)133361158);
        List<Coordinates> exons = List.of(Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356549, (int)133356670), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356913, (int)133357068), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133357710, (int)133357814), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133359949, (int)133360129), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133360264, (int)133360434), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133361055, (int)133361158));
        return Transcript.of((TranscriptIdentifier)txId, (GenomicRegion)location, exons, (Coordinates)location.coordinates(), (TranscriptMetadata)TranscriptMetadata.of((TranscriptEvidence)TranscriptEvidence.MANUAL_ANNOTATION));
    }

    public static Gene surf1() {
        Contig contig = ASSEMBLY.contigByName("chr9");
        GeneIdentifier id = GeneIdentifier.of((String)"ENSG00000148290.10", (String)"SURF1", (String)"HGNC:11474", (String)"NCBIGene:6834");
        GenomicRegion location = (GenomicRegion)GenomicRegion.of((Contig)contig, (Strand)Strand.POSITIVE, (CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351757, (int)133356676).toNegativeStrand();
        Transcript surf1_201 = Genes.surf1_201(contig);
        Transcript surf1_205 = Genes.surf1_205(contig);
        List<Transcript> transcripts = List.of(surf1_201, surf1_205);
        return Gene.of((GeneIdentifier)id, (GenomicRegion)location, transcripts);
    }

    public static Transcript surf1_201(Contig contig) {
        TranscriptIdentifier txId = TranscriptIdentifier.of((String)"ENST00000371974.8", (String)"SURF1-201", (String)"CCDS6966.1");
        GenomicRegion location = (GenomicRegion)GenomicRegion.of((Contig)contig, (Strand)Strand.POSITIVE, (CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351757, (int)133356487).toNegativeStrand();
        List<Coordinates> exons = List.of(Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356399, (int)133356487).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356268, (int)133356320).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133354823, (int)133354957).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133354658, (int)133354741).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133353748, (int)133353940).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133352693, (int)133352766).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133352445, (int)133352608).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133352060, (int)133352142).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351757, (int)133351982).invert(contig));
        Coordinates cdsCoordinates = Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351912, (int)133356453).invert(contig);
        return Transcript.of((TranscriptIdentifier)txId, (GenomicRegion)location, exons, (Coordinates)cdsCoordinates, (TranscriptMetadata)TranscriptMetadata.of((TranscriptEvidence)TranscriptEvidence.MANUAL_ANNOTATION));
    }

    public static Transcript surf1_205(Contig contig) {
        TranscriptIdentifier txId = TranscriptIdentifier.of((String)"ENST00000615505.4", (String)"SURF1-205", (String)"CCDS75928.1");
        GenomicRegion location = (GenomicRegion)GenomicRegion.of((Contig)contig, (Strand)Strand.POSITIVE, (CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351804, (int)133356485).toNegativeStrand();
        List<Coordinates> exons = List.of(Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133356399, (int)133356485).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133354823, (int)133354957).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133354658, (int)133354741).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133353748, (int)133353940).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133352693, (int)133352766).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133352445, (int)133352608).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133352060, (int)133352142).invert(contig), Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351804, (int)133351982).invert(contig));
        Coordinates cdsCoordinates = Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)133351912, (int)133353936).invert(contig);
        return Transcript.of((TranscriptIdentifier)txId, (GenomicRegion)location, exons, (Coordinates)cdsCoordinates, (TranscriptMetadata)TranscriptMetadata.of((TranscriptEvidence)TranscriptEvidence.AUTOMATED_ANNOTATION));
    }
}

