/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model.impl;

import java.util.Objects;
import org.monarchinitiative.sgenes.model.Identifier;

abstract class IdentifierDefault
implements Identifier {
    private final String accession;
    private final String symbol;

    IdentifierDefault(String accession, String symbol) {
        this.accession = Objects.requireNonNull(accession, "Accession must not be null");
        this.symbol = Objects.requireNonNull(symbol, "Symbol must not be null");
    }

    @Override
    public String accession() {
        return this.accession;
    }

    @Override
    public String symbol() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierDefault that = (IdentifierDefault)o;
        return Objects.equals(this.accession, that.accession) && Objects.equals(this.symbol, that.symbol);
    }

    public int hashCode() {
        return Objects.hash(this.accession, this.symbol);
    }

    public String toString() {
        return "IdentifierDefault{accession='" + this.accession + "', symbol='" + this.symbol + "'}";
    }
}

