/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model.base;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.model.CodingTranscript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.sgenes.model.TranscriptMetadata;
import org.monarchinitiative.sgenes.model.base.BaseTranscript;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public abstract class BaseCodingTranscript
extends BaseTranscript
implements CodingTranscript {
    private final Coordinates cdsCoordinates;

    protected BaseCodingTranscript(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates, TranscriptMetadata metadata) {
        super(id, location, exons, metadata);
        this.cdsCoordinates = Objects.requireNonNull(cdsCoordinates, "CDS coordinates must not be null");
    }

    @Override
    public Coordinates cdsCoordinates() {
        return this.cdsCoordinates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseCodingTranscript that = (BaseCodingTranscript)o;
        return Objects.equals(this.cdsCoordinates, that.cdsCoordinates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cdsCoordinates);
    }

    @Override
    public String toString() {
        return "BaseCodingTranscript{id=" + String.valueOf(this.id()) + ", location=" + String.valueOf(this.location()) + ", exons=" + String.valueOf(this.exons()) + ", cdsCoordinates=" + String.valueOf(this.cdsCoordinates()) + "}";
    }
}

