/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model;

import java.util.List;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.svart.CoordinateSystem;
import org.monarchinitiative.svart.Coordinates;

public interface Coding {
    public Coordinates cdsCoordinates();

    default public Coordinates startCodon() {
        return Coordinates.of((CoordinateSystem)this.cdsCoordinates().coordinateSystem(), (int)this.cdsCoordinates().start(), (int)(this.cdsCoordinates().end() + 3));
    }

    default public Coordinates stopCodon() {
        return Coordinates.of((CoordinateSystem)this.cdsCoordinates().coordinateSystem(), (int)(this.cdsCoordinates().end() - 3), (int)this.cdsCoordinates().end());
    }

    default public int codingStart() {
        return this.startCodon().start();
    }

    default public int codingStartWithCoordinateSystem(CoordinateSystem target) {
        return this.startCodon().startWithCoordinateSystem(target);
    }

    default public int codingEnd() {
        return this.stopCodon().end() - this.stopCodon().length();
    }

    default public int codingEndWithCoordinateSystem(CoordinateSystem target) {
        return this.stopCodon().endWithCoordinateSystem(target) - this.stopCodon().length();
    }

    default public int cdsLength() {
        if (this instanceof Transcript) {
            return this.cdsLength(this.startCodon(), this.stopCodon(), ((Transcript)((Object)this)).exons());
        }
        return this.stopCodon().endWithCoordinateSystem(CoordinateSystem.zeroBased()) - this.startCodon().startWithCoordinateSystem(CoordinateSystem.zeroBased()) - this.stopCodon().length();
    }

    private int cdsLength(Coordinates startCodon, Coordinates stopCodon, List<Coordinates> exons) {
        int cdsLength = 0;
        for (Coordinates exon : exons) {
            int start = Math.max(Math.min(startCodon.startWithCoordinateSystem(CoordinateSystem.zeroBased()), exon.endWithCoordinateSystem(CoordinateSystem.zeroBased())), exon.startWithCoordinateSystem(CoordinateSystem.zeroBased()));
            int end = Math.min(Math.max(stopCodon.endWithCoordinateSystem(CoordinateSystem.zeroBased()), exon.startWithCoordinateSystem(CoordinateSystem.zeroBased())), exon.endWithCoordinateSystem(CoordinateSystem.zeroBased()));
            cdsLength += end - start;
        }
        return cdsLength - stopCodon.length();
    }
}

