/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.monarchinitiative.sgenes.model.Annotated;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.sgenes.model.base.BaseGene;
import org.monarchinitiative.svart.GenomicRegion;

public class GeneDefault
extends BaseGene {
    private final List<? extends Transcript> transcripts;

    public GeneDefault(GeneIdentifier id, GenomicRegion location, List<? extends Transcript> transcripts) {
        super(id, location);
        this.transcripts = Objects.requireNonNull(transcripts, "Transcripts must not be null");
        this.check();
    }

    private void check() {
        if (this.transcripts.isEmpty()) {
            throw new IllegalStateException("Transcript list must not be empty");
        }
        List evidences = this.transcripts.stream().map(Annotated::featureSource).flatMap(Optional::stream).distinct().collect(Collectors.toList());
        if (evidences.size() > 1) {
            throw new IllegalStateException("Gene must not have transcripts defined by multiple sources");
        }
    }

    @Override
    public Iterator<? extends Transcript> transcripts() {
        return this.transcripts.iterator();
    }

    @Override
    public int transcriptCount() {
        return this.transcripts.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneDefault that = (GeneDefault)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.location, that.location) && Objects.equals(this.transcripts, that.transcripts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.location, this.transcripts);
    }

    @Override
    public String toString() {
        return "GeneDefault{id=" + this.id + ", location=" + this.location + ", transcripts=" + this.transcripts + "}";
    }
}

