/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model.base;

import java.util.Objects;
import org.monarchinitiative.sgenes.model.Gene;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.svart.GenomicRegion;

public abstract class BaseGene
implements Gene {
    protected final GeneIdentifier id;
    protected final GenomicRegion location;

    protected BaseGene(GeneIdentifier id, GenomicRegion location) {
        this.id = Objects.requireNonNull(id, "ID must not be null");
        this.location = Objects.requireNonNull(location, "Location must not be null");
    }

    @Override
    public GeneIdentifier id() {
        return this.id;
    }

    @Override
    public GenomicRegion location() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseGene baseGene = (BaseGene)o;
        return Objects.equals(this.id, baseGene.id) && Objects.equals(this.location, baseGene.location);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.location);
    }

    public String toString() {
        return "BaseGene{id=" + this.id + ", location=" + this.location + "}";
    }
}

