/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io.json.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.monarchinitiative.sgenes.model.CodingTranscript;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.svart.Coordinates;

public class TranscriptSerializer
extends StdSerializer<Transcript> {
    private static final long serialVersionUID = 1L;

    public TranscriptSerializer() {
        this(Transcript.class);
    }

    protected TranscriptSerializer(Class<Transcript> t) {
        super(t);
    }

    public void serialize(Transcript tx, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField("id", (Object)tx.id());
        gen.writeObjectField("loc", (Object)tx.location());
        gen.writeArrayFieldStart("exons");
        for (Coordinates exon : tx.exons()) {
            gen.writeObject((Object)exon);
        }
        gen.writeEndArray();
        if (tx instanceof CodingTranscript) {
            CodingTranscript coding = (CodingTranscript)tx;
            gen.writeObjectField("cdsCoordinates", (Object)coding.cdsCoordinates());
        }
        gen.writeEndObject();
    }
}

