/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.monarchinitiative.sgenes.model.Gene;

public interface GeneParser {
    public void write(List<? extends Gene> var1, OutputStream var2) throws IOException;

    default public void write(List<? extends Gene> genes, Path destination) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(destination, new OpenOption[0]);){
            this.write(genes, outputStream);
        }
    }

    public List<? extends Gene> read(InputStream var1) throws IOException;

    default public List<? extends Gene> read(Path source) throws IOException {
        try (InputStream inputStream = Files.newInputStream(source, new OpenOption[0]);){
            List<? extends Gene> list = this.read(inputStream);
            return list;
        }
    }
}

