/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.refseq;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.Biotype;
import org.monarchinitiative.sgenes.gtf.model.RefseqSource;
import org.monarchinitiative.sgenes.gtf.model.RefseqTranscript;
import org.monarchinitiative.sgenes.gtf.model.RefseqTranscriptMetadata;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.sgenes.model.TranscriptMetadata;
import org.monarchinitiative.sgenes.model.base.BaseTranscript;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public class RefseqNoncodingTranscript
extends BaseTranscript
implements RefseqTranscript {
    private final RefseqSource source;

    public static RefseqNoncodingTranscript of(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, RefseqSource source, RefseqTranscriptMetadata metadata) {
        return new RefseqNoncodingTranscript(id, location, exons, source, metadata);
    }

    protected RefseqNoncodingTranscript(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, RefseqSource source, RefseqTranscriptMetadata metadata) {
        super(id, location, exons, (TranscriptMetadata)metadata);
        this.source = Objects.requireNonNull(source, "Refseq source must not be null");
    }

    @Override
    public RefseqSource source() {
        return this.source;
    }

    @Override
    public Biotype biotype() {
        return ((RefseqTranscriptMetadata)this.metadata()).biotype();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RefseqNoncodingTranscript that = (RefseqNoncodingTranscript)o;
        return this.source == that.source;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.source});
    }

    public String toString() {
        return "RefseqNoncodingTranscript{id=" + String.valueOf(this.id()) + ", source=" + String.valueOf((Object)this.source) + ", location=" + String.valueOf(this.location()) + ", exons=" + String.valueOf(this.exons()) + ", metadata=" + String.valueOf(this.metadata()) + "}";
    }
}

