/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.refseq;

import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.sgenes.model.GeneIdentifier;

public class RefseqGeneIdentifier
implements GeneIdentifier {
    private final String ncbiGeneId;
    private final String symbol;
    private final String hgncGeneId;

    public static RefseqGeneIdentifier of(String ncbiGeneId, String symbol, String hgncGeneId) {
        return new RefseqGeneIdentifier(ncbiGeneId, symbol, hgncGeneId);
    }

    private RefseqGeneIdentifier(String ncbiGeneId, String symbol, String hgncGeneId) {
        this.ncbiGeneId = ncbiGeneId;
        this.symbol = symbol;
        this.hgncGeneId = hgncGeneId;
    }

    public String accession() {
        return this.ncbiGeneId;
    }

    public String symbol() {
        return this.symbol;
    }

    public Optional<String> hgncId() {
        return Optional.ofNullable(this.hgncGeneId);
    }

    public Optional<String> ncbiGeneId() {
        return Optional.of(this.ncbiGeneId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefseqGeneIdentifier that = (RefseqGeneIdentifier)o;
        return Objects.equals(this.ncbiGeneId, that.ncbiGeneId) && Objects.equals(this.symbol, that.symbol) && Objects.equals(this.hgncGeneId, that.hgncGeneId);
    }

    public int hashCode() {
        return Objects.hash(this.ncbiGeneId, this.symbol, this.hgncGeneId);
    }

    public String toString() {
        return "RefseqGeneIdentifier{symbol='" + this.symbol + "', ncbiGeneId='" + this.ncbiGeneId + "', hgncGeneId='" + this.hgncGeneId + "'}";
    }
}

