/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.gencode;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.GencodeTranscriptMetadata;
import org.monarchinitiative.sgenes.gtf.model.impl.gencode.GencodeNoncodingTranscript;
import org.monarchinitiative.sgenes.model.CodingTranscript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public class GencodeCodingTranscript
extends GencodeNoncodingTranscript
implements CodingTranscript {
    private final Coordinates cdsCoordinates;

    public static GencodeCodingTranscript of(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates, GencodeTranscriptMetadata metadata) {
        return new GencodeCodingTranscript(id, location, exons, cdsCoordinates, metadata);
    }

    private GencodeCodingTranscript(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates, GencodeTranscriptMetadata metadata) {
        super(id, location, exons, metadata);
        this.cdsCoordinates = Objects.requireNonNull(cdsCoordinates, "CDS coordinates must not be null");
    }

    public Coordinates cdsCoordinates() {
        return this.cdsCoordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GencodeCodingTranscript that = (GencodeCodingTranscript)o;
        return Objects.equals(this.cdsCoordinates, that.cdsCoordinates);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cdsCoordinates);
    }

    @Override
    public String toString() {
        return "GencodeCodingTranscript{id=" + String.valueOf(this.id()) + ", metadata=" + String.valueOf(this.metadata()) + ", location=" + String.valueOf(this.location()) + ", exons=" + String.valueOf(this.exons()) + ", cdsCoordinates=" + String.valueOf(this.cdsCoordinates) + "}";
    }
}

