/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfFeature;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfFrame;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfRecord;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfSource;
import org.monarchinitiative.svart.Contig;
import org.monarchinitiative.svart.CoordinateSystem;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;
import org.monarchinitiative.svart.Strand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InferTranscriptRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferTranscriptRecord.class);

    private InferTranscriptRecord() {
    }

    static Collection<? extends GtfRecord> inferTranscriptRecords(GtfRecord gene, Map<String, List<GtfRecord>> exonMap) {
        ArrayList<GtfRecord> transcripts = new ArrayList<GtfRecord>(exonMap.size());
        for (Map.Entry<String, List<GtfRecord>> entry : exonMap.entrySet()) {
            String txAccession = entry.getKey();
            List<GtfRecord> exons = entry.getValue();
            if (exons.isEmpty()) {
                LOGGER.warn("No exons found for transcript {}", (Object)txAccession);
                continue;
            }
            GenomicRegion location = InferTranscriptRecord.inferTranscriptLocation(exons);
            GtfSource source = InferTranscriptRecord.inferSource(exons);
            Map<String, List<String>> attributes = InferTranscriptRecord.parseAttributes(gene, exons);
            if (attributes.isEmpty()) continue;
            Set<String> tags = Set.of();
            transcripts.add(GtfRecord.of(location, source, GtfFeature.TRANSCRIPT, GtfFrame.NA, attributes, tags));
        }
        return transcripts;
    }

    private static GenomicRegion inferTranscriptLocation(List<GtfRecord> exons) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (GtfRecord exon : exons) {
            start = Math.min(start, exon.startWithCoordinateSystem(CoordinateSystem.zeroBased()));
            end = Math.max(end, exon.endWithCoordinateSystem(CoordinateSystem.zeroBased()));
        }
        GtfRecord first = exons.get(0);
        Coordinates coordinates = Coordinates.of((CoordinateSystem)CoordinateSystem.zeroBased(), (int)start, (int)end);
        return GenomicRegion.of((Contig)first.contig(), (Strand)first.strand(), (Coordinates)coordinates);
    }

    private static GtfSource inferSource(List<GtfRecord> exons) {
        return exons.get(0).source();
    }

    private static Map<String, List<String>> parseAttributes(GtfRecord gene, List<GtfRecord> exons) {
        GtfRecord first = exons.get(0);
        if (!first.hasAttribute("product")) {
            LOGGER.warn("Unable to infer transcript name for {}: `product` field is missing", (Object)first.firstAttribute("transcript_id"));
            return Map.of();
        }
        return Map.of("gene_id", gene.attribute("gene_id"), "transcript_id", first.attribute("transcript_id"), "product", first.attribute("product"), "transcript_biotype", first.attribute("gbkey").stream().map(InferTranscriptRecord.toBiotype()).collect(Collectors.toList()));
    }

    private static Function<String, String> toBiotype() {
        return attr -> {
            switch (attr.toLowerCase()) {
                case "mrna": {
                    return "protein_coding";
                }
                case "rrna": {
                    return "rrna";
                }
                case "ncrna": {
                    return "ncrna";
                }
                case "precursor_rna": 
                case "c_region": 
                case "misc_rna": {
                    return "misc_rna";
                }
            }
            return "unknown";
        };
    }
}

