/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.io.gtf;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfFeature;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfFrame;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfSource;
import org.monarchinitiative.sgenes.model.Located;
import org.monarchinitiative.svart.GenomicRegion;

public class GtfRecord
implements Located {
    private final GenomicRegion location;
    private final GtfSource source;
    private final GtfFeature feature;
    private final GtfFrame frame;
    private final Map<String, List<String>> attributes;
    private final Set<String> tags;

    public static GtfRecord of(GenomicRegion location, GtfSource source, GtfFeature feature, GtfFrame frame, Map<String, List<String>> attributes, Set<String> tags) {
        Objects.requireNonNull(location, "Location must not be null");
        Objects.requireNonNull(source, "GtfSource must not be null");
        Objects.requireNonNull(feature, "GtfFeature must not be null");
        Objects.requireNonNull(frame, "GtfFrame must not be null");
        Objects.requireNonNull(attributes, "Attributes map must not be null");
        Objects.requireNonNull(tags, "Tags must not be null");
        List<String> geneId = attributes.get("gene_id");
        if (geneId == null || geneId.isEmpty()) {
            throw new IllegalArgumentException("Missing the mandatory `gene_id` attribute: " + String.valueOf(attributes));
        }
        return new GtfRecord(location, source, feature, frame, Map.copyOf(attributes), tags);
    }

    private GtfRecord(GenomicRegion location, GtfSource source, GtfFeature feature, GtfFrame frame, Map<String, List<String>> attributes, Set<String> tags) {
        this.location = location;
        this.source = source;
        this.feature = feature;
        this.frame = frame;
        this.attributes = attributes;
        this.tags = tags;
    }

    public GenomicRegion location() {
        return this.location;
    }

    public GtfSource source() {
        return this.source;
    }

    public GtfFeature feature() {
        return this.feature;
    }

    public GtfFrame frame() {
        return this.frame;
    }

    public String geneId() {
        return this.attributes.get("gene_id").get(0);
    }

    public boolean hasAttribute(String attribute) {
        return this.attributes.containsKey(attribute);
    }

    public Set<String> attributes() {
        return this.attributes.keySet();
    }

    public List<String> attribute(String key) {
        return this.attributes.get(key);
    }

    public String firstAttribute(String key) {
        List<String> values = this.attributes.get(key);
        return values != null ? values.get(0) : null;
    }

    public Set<String> tags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.source, this.feature, this.frame, this.attributes, this.tags});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GtfRecord gtfRecord = (GtfRecord)o;
        return Objects.equals(this.location, gtfRecord.location) && this.source == gtfRecord.source && this.feature == gtfRecord.feature && this.frame == gtfRecord.frame && Objects.equals(this.attributes, gtfRecord.attributes) && Objects.equals(this.tags, gtfRecord.tags);
    }

    public String toString() {
        return "GtfRecord{location=" + String.valueOf(this.location) + ", source=" + String.valueOf((Object)this.source) + ", feature=" + String.valueOf((Object)this.feature) + ", frame=" + String.valueOf((Object)this.frame) + ", attributes=" + String.valueOf(this.attributes) + ", tags=" + String.valueOf(this.tags) + "}";
    }
}

