/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.refseq;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.RefseqMetadata;
import org.monarchinitiative.sgenes.gtf.model.RefseqTranscript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.sgenes.model.base.BaseTranscript;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public class RefseqNoncodingTranscript
extends BaseTranscript
implements RefseqTranscript {
    private final RefseqMetadata refseqMetadata;

    public static RefseqNoncodingTranscript of(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, RefseqMetadata refseqMetadata) {
        return new RefseqNoncodingTranscript(id, location, exons, refseqMetadata);
    }

    protected RefseqNoncodingTranscript(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, RefseqMetadata refseqMetadata) {
        super(id, location, exons);
        this.refseqMetadata = Objects.requireNonNull(refseqMetadata, "Refseq metadata must not be null");
    }

    @Override
    public RefseqMetadata refseqMetadata() {
        return this.refseqMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RefseqNoncodingTranscript that = (RefseqNoncodingTranscript)o;
        return Objects.equals(this.refseqMetadata, that.refseqMetadata);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.refseqMetadata);
    }

    public String toString() {
        return "RefseqNoncodingTranscript{id=" + this.id() + ", location=" + this.location() + ", exons=" + this.exons() + "refseqMetadata=" + this.refseqMetadata + "}";
    }
}

