/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.refseq;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.RefseqGene;
import org.monarchinitiative.sgenes.gtf.model.RefseqMetadata;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.sgenes.model.base.BaseGene;
import org.monarchinitiative.svart.GenomicRegion;

public class RefseqGeneImpl
extends BaseGene
implements RefseqGene {
    private final List<? extends Transcript> transcripts;
    private final RefseqMetadata refseqMetadata;

    public static RefseqGeneImpl of(GeneIdentifier identifier, GenomicRegion location, List<? extends Transcript> transcripts, RefseqMetadata refseqMetadata) {
        return new RefseqGeneImpl(identifier, location, transcripts, refseqMetadata);
    }

    private RefseqGeneImpl(GeneIdentifier identifier, GenomicRegion location, List<? extends Transcript> transcripts, RefseqMetadata refseqMetadata) {
        super(identifier, location);
        this.transcripts = Objects.requireNonNull(transcripts, "Transcripts must not be null");
        if (this.transcripts.isEmpty()) {
            throw new IllegalArgumentException("Transcripts must not be empty");
        }
        this.refseqMetadata = Objects.requireNonNull(refseqMetadata, "Refseq metadata must not be empty");
    }

    public Iterator<? extends Transcript> transcripts() {
        return this.transcripts.iterator();
    }

    public int transcriptCount() {
        return this.transcripts.size();
    }

    @Override
    public RefseqMetadata refseqMetadata() {
        return this.refseqMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RefseqGeneImpl that = (RefseqGeneImpl)o;
        return Objects.equals(this.transcripts, that.transcripts) && Objects.equals(this.refseqMetadata, that.refseqMetadata);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transcripts, this.refseqMetadata);
    }

    public String toString() {
        return "RefseqGeneImpl{id=" + this.id + ", location=" + this.location + ", transcripts=" + this.transcripts + ", refseqMetadata=" + this.refseqMetadata + "} " + super.toString();
    }
}

