/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.gencode;

import java.util.Objects;
import java.util.Set;
import org.monarchinitiative.sgenes.gtf.model.Biotype;
import org.monarchinitiative.sgenes.gtf.model.EvidenceLevel;
import org.monarchinitiative.sgenes.gtf.model.GencodeMetadata;

public class GencodeMetadataImpl
implements GencodeMetadata {
    private final Biotype biotype;
    private final EvidenceLevel evidenceLevel;
    private final Set<String> tags;

    public static GencodeMetadataImpl of(Biotype biotype, EvidenceLevel evidenceLevel, Set<String> tags) {
        return new GencodeMetadataImpl(biotype, evidenceLevel, tags);
    }

    private GencodeMetadataImpl(Biotype biotype, EvidenceLevel evidenceLevel, Set<String> tags) {
        this.biotype = Objects.requireNonNull(biotype, "Biotype must not be null");
        this.evidenceLevel = Objects.requireNonNull(evidenceLevel, "Evidence level must not be null");
        this.tags = Objects.requireNonNull(tags, "Tags must not be null");
    }

    @Override
    public Biotype biotype() {
        return this.biotype;
    }

    @Override
    public EvidenceLevel evidenceLevel() {
        return this.evidenceLevel;
    }

    @Override
    public Set<String> tags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GencodeMetadataImpl that = (GencodeMetadataImpl)o;
        return this.biotype == that.biotype && this.evidenceLevel == that.evidenceLevel && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.biotype, this.evidenceLevel, this.tags});
    }

    public String toString() {
        return "GencodeMetadataImpl{biotype=" + this.biotype + ", evidenceLevel=" + this.evidenceLevel + ", tags=" + this.tags + "}";
    }
}

