/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.gencode;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.GencodeGene;
import org.monarchinitiative.sgenes.gtf.model.GencodeMetadata;
import org.monarchinitiative.sgenes.gtf.model.GencodeTranscript;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.base.BaseGene;
import org.monarchinitiative.svart.GenomicRegion;

public class GencodeGeneImpl
extends BaseGene
implements GencodeGene {
    private final List<? extends GencodeTranscript> transcripts;
    private final GencodeMetadata gencodeMetadata;

    public static GencodeGeneImpl of(GeneIdentifier id, GenomicRegion location, List<GencodeTranscript> transcripts, GencodeMetadata gencodeMetadata) {
        return new GencodeGeneImpl(id, location, transcripts, gencodeMetadata);
    }

    private GencodeGeneImpl(GeneIdentifier id, GenomicRegion location, List<GencodeTranscript> transcripts, GencodeMetadata gencodeMetadata) {
        super(id, location);
        this.transcripts = Objects.requireNonNull(transcripts, "Transcripts must not be null");
        if (this.transcripts.isEmpty()) {
            throw new IllegalArgumentException("Transcripts must not be empty");
        }
        this.gencodeMetadata = Objects.requireNonNull(gencodeMetadata, "Gencode metadata must not be null");
    }

    @Override
    public GencodeMetadata gencodeMetadata() {
        return this.gencodeMetadata;
    }

    @Override
    public Iterator<? extends GencodeTranscript> transcripts() {
        return this.transcripts.iterator();
    }

    public int transcriptCount() {
        return this.transcripts.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GencodeGeneImpl that = (GencodeGeneImpl)o;
        return Objects.equals(this.transcripts, that.transcripts) && Objects.equals(this.gencodeMetadata, that.gencodeMetadata);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transcripts, this.gencodeMetadata);
    }

    public String toString() {
        return "GencodeGeneImpl{transcripts=" + this.transcripts + ", gencodeMetadata=" + this.gencodeMetadata + "} " + super.toString();
    }
}

