/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.monarchinitiative.phenol.io.utils.CurieUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class CurieUtilBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurieUtilBuilder.class);
    private static final Map<String, String> DEFAULT_CURIE_MAP = Map.copyOf(CurieUtilBuilder.generate());
    private static final CurieUtil DEFAULT_CURIE_UTIL = CurieUtil.of(DEFAULT_CURIE_MAP);

    private CurieUtilBuilder() {
    }

    public static Map<String, String> defaultCurieMap() {
        return DEFAULT_CURIE_MAP;
    }

    public static CurieUtil defaultCurieUtil() {
        return DEFAULT_CURIE_UTIL;
    }

    public static CurieUtil withDefaultsAnd(Map<String, String> additionalCuries) {
        HashMap<String, String> merged = new HashMap<String, String>();
        merged.putAll(DEFAULT_CURIE_MAP);
        merged.putAll(additionalCuries);
        return CurieUtil.of(Map.copyOf(merged));
    }

    public static CurieUtil just(Map<String, String> curies) {
        return CurieUtil.of(Map.copyOf(curies));
    }

    private static Map<String, String> generate() {
        Map map;
        block8: {
            InputStream is = CurieUtilBuilder.class.getClassLoader().getResourceAsStream("curie_map.yaml");
            try {
                Yaml yaml = new Yaml();
                map = (Map)yaml.load(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return Map.of();
                }
            }
            is.close();
        }
        return map;
    }
}

