/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obographs;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.Node;
import org.geneontology.obographs.core.model.meta.BasicPropertyValue;
import org.geneontology.obographs.core.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.core.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.core.model.meta.XrefPropertyValue;
import org.monarchinitiative.phenol.ontology.data.Dbxref;
import org.monarchinitiative.phenol.ontology.data.SimpleXref;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermSynonym;
import org.monarchinitiative.phenol.ontology.data.TermSynonymScope;
import org.monarchinitiative.phenol.ontology.data.TermXref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboGraphTermFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OboGraphTermFactory.class);

    public Term constructTerm(Node node, TermId termId) {
        ImmutableList subsets;
        Term.Builder termBuilder = Term.builder();
        termBuilder.id(termId);
        String label = node.getLabel();
        termBuilder.name(label == null ? "" : label);
        Meta meta = node.getMeta();
        if (meta == null) {
            LOGGER.debug("No meta instance exists for node: {} {}", (Object)node.getId(), (Object)node.getLabel());
            return termBuilder.build();
        }
        DefinitionPropertyValue definitionPropertyValue = meta.getDefinition();
        String definition = this.getDefinition(definitionPropertyValue);
        termBuilder.definition(definition);
        List<SimpleXref> simpleXrefs = this.convertToXrefs(definitionPropertyValue);
        termBuilder.databaseXrefs(simpleXrefs);
        ImmutableList comments = meta.getComments();
        if (comments != null) {
            termBuilder.comment(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)comments));
        }
        if ((subsets = meta.getSubsets()) != null) {
            termBuilder.subsets((List)subsets);
        }
        List<TermSynonym> termSynonyms = this.convertToSynonyms((List<SynonymPropertyValue>)meta.getSynonyms());
        termBuilder.synonyms(termSynonyms);
        List<Dbxref> xrefs = this.convertToDbXrefs((List<XrefPropertyValue>)meta.getXrefs());
        termBuilder.xrefs(xrefs);
        boolean isObsolete = this.isObsolete(meta);
        termBuilder.obsolete(isObsolete);
        List<TermId> altIds = this.convertToAltIds((List<BasicPropertyValue>)meta.getBasicPropertyValues());
        termBuilder.altTermIds(altIds);
        return termBuilder.build();
    }

    private String getDefinition(DefinitionPropertyValue definitionPropertyValue) {
        return definitionPropertyValue == null ? "" : definitionPropertyValue.getVal();
    }

    private List<SimpleXref> convertToXrefs(DefinitionPropertyValue definitionPropertyValue) {
        if (definitionPropertyValue == null) {
            return List.of();
        }
        ImmutableList xrefs = definitionPropertyValue.getXrefs();
        if (xrefs == null) {
            return List.of();
        }
        ArrayList<SimpleXref> simpleXrefBuilder = new ArrayList<SimpleXref>();
        for (String xref : xrefs) {
            SimpleXref sxref = new SimpleXref(xref);
            if (!sxref.isValid()) continue;
            simpleXrefBuilder.add(sxref);
        }
        return List.copyOf(simpleXrefBuilder);
    }

    private List<TermSynonym> convertToSynonyms(List<SynonymPropertyValue> spvs) {
        if (spvs == null) {
            return List.of();
        }
        ArrayList<TermSynonym> termSynonymBuilder = new ArrayList<TermSynonym>();
        for (SynonymPropertyValue spv : spvs) {
            TermSynonymScope scope = null;
            if (spv.isExact()) {
                scope = TermSynonymScope.EXACT;
            } else if (spv.isBroad()) {
                scope = TermSynonymScope.BROAD;
            } else if (spv.isNarrow()) {
                scope = TermSynonymScope.NARROW;
            } else if (spv.isRelated()) {
                scope = TermSynonymScope.RELATED;
            }
            String synonymType = spv.getSynonymType();
            String synonymTypeName = String.join((CharSequence)", ", spv.getTypes());
            ImmutableList xrefs = spv.getXrefs();
            List<TermXref> termXrefs = this.mapXref((List<String>)xrefs);
            TermSynonym its = new TermSynonym(spv.getVal(), scope, synonymTypeName, termXrefs, synonymType);
            termSynonymBuilder.add(its);
        }
        return List.copyOf(termSynonymBuilder);
    }

    private List<TermXref> mapXref(List<String> xrefs) {
        ArrayList<TermXref> termXrefBuilder = new ArrayList<TermXref>();
        for (String xref : xrefs) {
            try {
                TermId xrefTermId = TermId.of((String)xref);
                TermXref trf = new TermXref(xrefTermId, "");
                termXrefBuilder.add(trf);
            }
            catch (Exception exception) {}
        }
        return List.copyOf(termXrefBuilder);
    }

    private List<Dbxref> convertToDbXrefs(List<XrefPropertyValue> xrefPropertyValues) {
        if (xrefPropertyValues == null || xrefPropertyValues.isEmpty()) {
            return List.of();
        }
        ArrayList<Dbxref> dbxrefs = new ArrayList<Dbxref>();
        for (XrefPropertyValue xrefPropertyValue : xrefPropertyValues) {
            String val = xrefPropertyValue.getVal();
            if (val == null) continue;
            dbxrefs.add(new Dbxref(val, null, null));
        }
        return List.copyOf(dbxrefs);
    }

    private boolean isObsolete(Meta meta) {
        try {
            Field f = Meta.class.getDeclaredField("deprecated");
            f.setAccessible(true);
            Boolean deprecated = (Boolean)f.get(meta);
            if (deprecated == null) {
                return false;
            }
            return deprecated;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    private List<TermId> convertToAltIds(List<BasicPropertyValue> basicPropertyValues) {
        if (basicPropertyValues == null || basicPropertyValues.isEmpty()) {
            return List.of();
        }
        ArrayList<TermId> altIdsBuilder = new ArrayList<TermId>();
        for (BasicPropertyValue bpv : basicPropertyValues) {
            if (!"http://www.geneontology.org/formats/oboInOwl#hasAlternativeId".equals(bpv.getPred())) continue;
            String altId = bpv.getVal();
            altIdsBuilder.add(TermId.of((String)altId));
        }
        return List.copyOf(altIdsBuilder);
    }
}

