/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.geneontology.obographs.model.GraphDocument;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.io.obographs.OboGraphDocumentAdaptor;
import org.monarchinitiative.phenol.io.obographs.OboGraphDocumentLoader;
import org.monarchinitiative.phenol.io.utils.CurieUtilBuilder;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.prefixcommons.CurieUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private static final Logger logger = LoggerFactory.getLogger(OntologyLoader.class);

    private OntologyLoader() {
    }

    public static Ontology loadOntology(File file) {
        return OntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static Ontology loadOntology(File file, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static Ontology loadOntology(File file, CurieUtil curieUtil, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoader.loadGraphDocument(file);
        return OntologyLoader.loadOntology(graphDocument, curieUtil, termIdPrefixes);
    }

    public static Ontology loadOntology(InputStream inputStream) {
        return OntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static Ontology loadOntology(InputStream inputStream, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static Ontology loadOntology(InputStream inputStream, CurieUtil curieUtil, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoader.loadGraphDocument(inputStream);
        return OntologyLoader.loadOntology(graphDocument, curieUtil, termIdPrefixes);
    }

    public static Ontology loadOntology(GraphDocument graphDocument, CurieUtil curieUtil, String ... termIdPrefixes) {
        logger.debug("Finished loading ontology");
        logger.debug("Creating phenol ontology");
        OboGraphDocumentAdaptor graphDocumentAdaptor = OboGraphDocumentAdaptor.builder().curieUtil(curieUtil).wantedTermIdPrefixes((Set<String>)ImmutableSet.copyOf((Object[])termIdPrefixes)).build(graphDocument);
        Ontology ontology = graphDocumentAdaptor.buildOntology();
        logger.debug("Parsed a total of {} terms", (Object)ontology.countAllTerms());
        return ontology;
    }

    private static GraphDocument loadGraphDocument(File file) {
        try {
            return OntologyLoader.loadGraphDocument(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Unable to load ontology", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GraphDocument loadGraphDocument(InputStream inputStream) {
        try {
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            int readlimit = 16;
            ((InputStream)bufferedStream).mark(readlimit);
            String firstBytes = OntologyLoader.readBytes(bufferedStream, readlimit);
            logger.debug("Read first bytes: " + firstBytes);
            if (OntologyLoader.isJsonGraphDoc(firstBytes)) {
                logger.debug("Looks like a JSON file...");
                try {
                    ((InputStream)bufferedStream).reset();
                    GraphDocument graphDocument = OboGraphDocumentLoader.loadJson(bufferedStream);
                    return graphDocument;
                }
                catch (Exception e) {
                    throw new PhenolRuntimeException("Error loading JSON", (Throwable)e);
                }
            }
            logger.debug("Looks like a OBO/OWL file...");
            try {
                ((InputStream)bufferedStream).reset();
                return OboGraphDocumentLoader.loadObo(bufferedStream);
            }
            catch (Exception e) {
                throw new PhenolRuntimeException("Error loading OBO/OWL", (Throwable)e);
            }
            finally {
                ((InputStream)bufferedStream).close();
            }
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Unable to load ontology", (Throwable)e);
        }
    }

    private static String readBytes(InputStream bufferedStream, int readlimit) throws IOException {
        byte[] firstFewBytes = new byte[readlimit];
        if (bufferedStream.read(firstFewBytes) == readlimit) {
            return new String(firstFewBytes);
        }
        return null;
    }

    private static boolean isJsonGraphDoc(String firstBytes) {
        return firstBytes != null && firstBytes.replace("\\W+", "").startsWith("{");
    }
}

