/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.assoc.GeneInfoGeneType;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItem;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItemContainer;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationData;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaders;
import org.monarchinitiative.phenol.cli.demo.MicaCalculator;
import org.monarchinitiative.phenol.cli.demo.MicaData;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.HpoResnikSimilarity;

public class ResnikGeneBasedHpoDemo {
    private final Ontology hpo;
    private final Map<TermId, HpoDisease> diseaseMap;
    private HpoResnikSimilarity resnikSimilarity;
    private final Map<TermId, Double> termToIc;
    private final Map<TermId, Collection<TermId>> geneToDiseaseMap;
    private final Map<TermId, String> geneIdToSymbolMap;
    private final Map<TermId, Collection<TermId>> diseaseIdToTermIds;

    public ResnikGeneBasedHpoDemo(Path hpoPath, Path hpoaPath, Path geneInfoPath, Path mim2genMedgenPath) throws IOException {
        this.hpo = ResnikGeneBasedHpoDemo.loadHpo(hpoPath);
        HpoDiseases hpoDiseases = ResnikGeneBasedHpoDemo.loadHpoDiseases(this.hpo, hpoaPath);
        this.diseaseMap = hpoDiseases.diseaseById();
        Instant t1 = Instant.now();
        HpoAssociationData hpoAssociationData = HpoAssociationData.builder((MinimalOntology)this.hpo).hpoDiseases((AnnotatedItemContainer)hpoDiseases).homoSapiensGeneInfo(geneInfoPath, Set.of(GeneInfoGeneType.protein_coding)).mim2GeneMedgen(mim2genMedgenPath).build();
        Instant t2 = Instant.now();
        System.out.printf("[INFO] Loaded geneInfo and mim2gene in %.3f seconds.\n", (double)Duration.between(t1, t2).toMillis() / 1000.0);
        this.geneToDiseaseMap = hpoAssociationData.associations().geneIdToDiseaseIds();
        System.out.println("[INFO] geneToDiseaseMap with " + this.geneToDiseaseMap.size() + " entries");
        this.geneIdToSymbolMap = hpoAssociationData.geneIdToSymbol();
        System.out.println("[INFO] geneIdToSymbolMap with " + this.geneIdToSymbolMap.size() + " entries");
        MicaCalculator calculator = new MicaCalculator((MinimalOntology)this.hpo, false);
        MicaData micaData = calculator.calculateMica((AnnotatedItemContainer<? extends AnnotatedItem>)hpoDiseases);
        this.diseaseIdToTermIds = micaData.diseaseIdToTermIds();
        this.termToIc = micaData.termToIc();
    }

    private static Ontology loadHpo(Path hpoPath) {
        Instant t1 = Instant.now();
        Ontology hpo = OntologyLoader.loadOntology((File)hpoPath.toFile());
        Instant t2 = Instant.now();
        System.out.printf("[INFO] Loaded HPO in %.3f seconds.\n", (double)Duration.between(t1, t2).toMillis() / 1000.0);
        return hpo;
    }

    private static HpoDiseases loadHpoDiseases(Ontology hpo, Path hpoaPath) throws IOException {
        Instant t1 = Instant.now();
        HpoDiseaseLoaderOptions options = HpoDiseaseLoaderOptions.of(Set.of(DiseaseDatabase.OMIM), (boolean)true, (int)5);
        HpoDiseaseLoader loader = HpoDiseaseLoaders.defaultLoader((MinimalOntology)hpo, (HpoDiseaseLoaderOptions)options);
        HpoDiseases hpoDiseases = loader.load(hpoaPath);
        Instant t2 = Instant.now();
        System.out.printf("[INFO] Loaded phenotype.hpoa in %.3f seconds.\n", (double)Duration.between(t1, t2).toMillis() / 1000.0);
        return hpoDiseases;
    }

    public void run() {
        Instant t1 = Instant.now();
        this.resnikSimilarity = new HpoResnikSimilarity((MinimalOntology)this.hpo, this.termToIc);
        Instant t2 = Instant.now();
        System.out.printf("[INFO] Calculated pairwise Resnik similarity in %.3f seconds.\n", (double)Duration.between(t1, t2).toMillis() / 1000.0);
        System.out.println("bla" + String.valueOf(Duration.between(t2, t1)));
        TermId arachnodactyly = TermId.of((String)"HP:0001166");
        TermId dolichocephaly = TermId.of((String)"HP:0000268");
        TermId ectopiaLentis = TermId.of((String)"HP:0001083");
        TermId aorticDissection = TermId.of((String)"HP:0002647");
        TermId striaeDistensae = TermId.of((String)"HP:0001065");
        ArrayList<TermId> marfanFeatures = new ArrayList<TermId>();
        marfanFeatures.add(arachnodactyly);
        marfanFeatures.add(dolichocephaly);
        marfanFeatures.add(ectopiaLentis);
        marfanFeatures.add(aorticDissection);
        marfanFeatures.add(striaeDistensae);
        TermId marfan = TermId.of((String)"OMIM:154700");
        this.differential(marfanFeatures, marfan);
        TermId tinnitus = TermId.of((String)"HP:0000360");
        TermId sensorineuralHearingImpairment = TermId.of((String)"HP:0000407");
        TermId bilateralVestibularSchwannoma = TermId.of((String)"HP:0009589");
        TermId epiretinalMembrane = TermId.of((String)"HP:0100014");
        TermId type2neurofibromatosis = TermId.of((String)"OMIM:101000");
        ArrayList<TermId> nf2Features = new ArrayList<TermId>();
        nf2Features.add(tinnitus);
        nf2Features.add(sensorineuralHearingImpairment);
        nf2Features.add(bilateralVestibularSchwannoma);
        nf2Features.add(epiretinalMembrane);
        this.differential(nf2Features, type2neurofibromatosis);
    }

    private void differential(List<TermId> hpoIds, TermId expectedDiseaseDiagnosis) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (TermId termId : this.geneToDiseaseMap.keySet()) {
            for (TermId diseaseId : this.geneToDiseaseMap.get(termId)) {
                Collection diseasehpoIds = this.diseaseIdToTermIds.getOrDefault(diseaseId, new ArrayList());
                double resnikScore = this.resnikSimilarity.computeScoreSymmetric(hpoIds, diseasehpoIds);
                String geneSymbol = this.geneIdToSymbolMap.get(termId);
                String gene = String.format("%s - %s", geneSymbol, termId.getValue());
                if (!this.diseaseMap.containsKey(diseaseId)) continue;
                String name = this.diseaseMap.get(diseaseId).diseaseName();
                String entry = String.format("%s - %s (%s)", name, diseaseId.getValue(), gene);
                results.put(entry, resnikScore);
            }
        }
        List<String> top10 = ResnikGeneBasedHpoDemo.topNKeys(results, 10);
        System.out.println("[INFO] Differential diagnosis for HPO terms:");
        for (TermId tid : hpoIds) {
            Optional opt = this.hpo.getTermLabel(tid);
            if (opt.isPresent()) {
                System.out.printf("\t%s (%s)\n", opt.get(), tid.getValue());
                continue;
            }
            System.err.println("[ERROR] Could not find label for " + tid.getValue());
        }
        String string = this.diseaseMap.get(expectedDiseaseDiagnosis).diseaseName();
        System.out.printf("[INFO] Expected diagnosis: %s\n", string);
        int c = 0;
        for (String dd : top10) {
            double p = results.getOrDefault(dd, 0.0);
            System.out.printf("%d) %s: %.2f\n", ++c, dd, p);
        }
    }

    public static List<String> topNKeys(HashMap<String, Double> map, int n) {
        PriorityQueue<String> topN = new PriorityQueue<String>(n, (s1, s2) -> Double.compare((Double)map.get(s2), (Double)map.get(s1)));
        for (String key : map.keySet()) {
            if (topN.size() < n) {
                topN.add(key);
                continue;
            }
            if (!(map.get(topN.peek()) < map.get(key))) continue;
            topN.poll();
            topN.add(key);
        }
        return new ArrayList<String>(topN);
    }
}

