/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.analysis.scoredist.TextFileScoreDistributionWriter;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.io.MinimalOntologyLoader;
import org.monarchinitiative.phenol.ontology.algo.InformationContentComputation;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermAnnotations;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.scoredist.ScoreDistribution;
import org.monarchinitiative.phenol.ontology.scoredist.ScoreSamplingOptions;
import org.monarchinitiative.phenol.ontology.scoredist.SimilarityScoreSampling;
import org.monarchinitiative.phenol.ontology.similarity.ResnikSimilarity;
import org.monarchinitiative.phenol.ontology.similarity.Similarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecomputeScores {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrecomputeScores.class);
    private final MinimalOntology hpo;
    private final List<TermId> phenotypicAbnormalityPrimaryTermIds;
    private final int numIterations;
    private final int seed;
    private final int numThreads;
    private final String outputScoreDistFile;
    private final HashMap<TermId, Collection<TermId>> termIdToObjectId = new HashMap();
    private final Map<TermId, Collection<TermId>> objectIdToTermId = new HashMap<TermId, Collection<TermId>>();
    private ResnikSimilarity resnikSimilarity;
    private Map<Integer, ScoreDistribution> scoreDistribution;

    public PrecomputeScores(String hpOboPath, int numIter, int seed, int numThreads, String outfile) {
        LOGGER.info("Loading ontology from OBO...");
        this.hpo = MinimalOntologyLoader.loadOntology((File)new File(hpOboPath));
        this.phenotypicAbnormalityPrimaryTermIds = this.hpo.graph().getDescendantsStream((Object)HpoSubOntologyRootTermIds.PHENOTYPIC_ABNORMALITY, true).collect(Collectors.toList());
        LOGGER.info("Done loading ontology.");
        this.numIterations = numIter;
        this.seed = seed;
        this.numThreads = numThreads;
        this.outputScoreDistFile = outfile;
    }

    public void run() {
        this.printHeader();
        this.loadOntology();
        this.precomputePairwiseResnik();
        this.performSampling();
        this.writeDistribution();
        this.printFooter();
    }

    private void printHeader() {
        LOGGER.info("Precomputing Scores");
        LOGGER.info("");
        LOGGER.info("Options");
        LOGGER.info("=======");
        LOGGER.info("");
    }

    private void loadOntology() {
        LOGGER.info("Loading gene-to-term link file...");
        ArrayList termAnnotations = new ArrayList();
        this.objectIdToTermId.putAll(TermAnnotations.constructTermLabelToAnnotationsMap((MinimalOntology)this.hpo, termAnnotations));
        LOGGER.info("Done loading gene-phenotype links.");
    }

    private void precomputePairwiseResnik() {
        LOGGER.info("Performing information content precomputation...");
        InformationContentComputation icPrecomputation = new InformationContentComputation(this.hpo);
        Map termToIc = icPrecomputation.computeInformationContent(this.termIdToObjectId);
        LOGGER.info("Done with precomputing information content.");
        LOGGER.info("Performing pairwise Resnik similarity precomputation...");
        this.resnikSimilarity = new ResnikSimilarity(this.hpo, termToIc, false);
        LOGGER.info("Done with precomputing pairwise Resnik similarity.");
    }

    private void performSampling() {
        LOGGER.info("Performing sampling...");
        ScoreSamplingOptions samplingOptions = new ScoreSamplingOptions(this.numThreads, null, null, 1, 20, this.seed, this.numIterations);
        SimilarityScoreSampling sampling = new SimilarityScoreSampling(this.phenotypicAbnormalityPrimaryTermIds, (Similarity)this.resnikSimilarity, samplingOptions, this.objectIdToTermId);
        this.scoreDistribution = sampling.performSampling();
        LOGGER.info("Done with sampling.");
    }

    private void writeDistribution() {
        LOGGER.info("Writing out score distribution...");
        int resolution = Math.min(1000, Math.max(100, this.numIterations / 100));
        try (TextFileScoreDistributionWriter writer = new TextFileScoreDistributionWriter(new File(this.outputScoreDistFile));){
            for (Map.Entry<Integer, ScoreDistribution> e : this.scoreDistribution.entrySet()) {
                writer.write(e.getKey().intValue(), e.getValue(), resolution);
            }
        }
        catch (IOException | PhenolException e) {
            throw new RuntimeException("Problem writing to file", e);
        }
        LOGGER.info("Done writing out distribution.");
    }

    private void printFooter() {
        LOGGER.info("All Done.\nHave a nice day!\n");
    }
}

