/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.assoc.GeneInfoGeneType;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItemContainer;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationData;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaders;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.ontology.algo.InformationContentComputation;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermIds;
import org.monarchinitiative.phenol.ontology.similarity.PairwiseSimilarity;
import org.monarchinitiative.phenol.ontology.similarity.PrecomputingPairwiseResnikSimilarity;
import org.monarchinitiative.phenol.ontology.similarity.ResnikSimilarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairwisePhenotypicSimilarityCalculator {
    private final Logger LOGGER = LoggerFactory.getLogger(PairwisePhenotypicSimilarityCalculator.class);
    private final Path pathHpObo;
    private final Path pathPhenotypeHpoa;
    private final Path outputFilename;
    private final Path mimgeneMedgenPath;
    private final Path geneInfoPath;
    private boolean doGeneBasedAnalysis;
    private Ontology hpo;
    private Map<TermId, HpoDisease> diseaseMap;
    private List<HpoDisease> diseaseList;
    private Map<TermId, Integer> diseaseIdToIndexMap;
    private ResnikSimilarity resnikSimilarity;
    private double[][] similarityScores;
    private Map<TermId, Collection<TermId>> geneToDiseaseMap;
    private Map<TermId, String> geneIdToSymbolMap;
    private int n_diseases;

    public PairwisePhenotypicSimilarityCalculator(Path hpoPath, Path hpoaPath, Path outname, Path geneInfoPath, Path mim2genMedgenPath) {
        this.pathHpObo = hpoPath;
        this.pathPhenotypeHpoa = hpoaPath;
        this.outputFilename = outname;
        this.geneInfoPath = geneInfoPath;
        this.mimgeneMedgenPath = mim2genMedgenPath;
        if (geneInfoPath == null || this.mimgeneMedgenPath == null) {
            this.doGeneBasedAnalysis = false;
            System.out.println("[INFO] We will perform disease-based phenotypic similarity analysis");
        } else {
            this.doGeneBasedAnalysis = true;
            System.out.println("[INFO] We will perform gene-based phenotypic similarity analysis");
        }
        boolean badFile = false;
        if (!Files.isRegularFile(this.pathHpObo, new LinkOption[0])) {
            System.err.println("[ERROR] hp.obo file not found at " + String.valueOf(this.pathHpObo));
            badFile = true;
        }
        if (!Files.isRegularFile(this.pathPhenotypeHpoa, new LinkOption[0])) {
            System.err.println("[ERROR] phenotype.hpoa file not found at " + String.valueOf(this.pathPhenotypeHpoa));
            badFile = true;
        }
        if (geneInfoPath == null || !Files.isRegularFile(geneInfoPath, new LinkOption[0])) {
            System.err.println("[ERROR] Homo_sapiens_gene_info.gz not found at " + String.valueOf(geneInfoPath));
            badFile = true;
        }
        if (this.mimgeneMedgenPath == null || !Files.isRegularFile(this.mimgeneMedgenPath, new LinkOption[0])) {
            System.err.println("[ERROR] mim2gene_medgen not found at " + String.valueOf(this.mimgeneMedgenPath));
            badFile = true;
        }
        if (badFile) {
            System.err.println("[ERROR] please correct paths and try again");
            System.exit(1);
        }
    }

    private double getMaximumGeneGeneSimilarity(TermId geneI, TermId geneJ) {
        double max = 0.0;
        Collection<TermId> diseasesI = this.geneToDiseaseMap.get(geneI);
        Collection<TermId> diseasesJ = this.geneToDiseaseMap.get(geneJ);
        if (diseasesI == null) {
            System.out.println("{Could not get diseases for gene " + geneI.getValue());
            return 0.0;
        }
        if (diseasesJ == null) {
            System.out.println("{Could not get diseases for gene " + geneJ.getValue());
            return 0.0;
        }
        for (TermId i : diseasesI) {
            for (TermId j : diseasesJ) {
                double s;
                Integer index_i = this.diseaseIdToIndexMap.get(i);
                Integer index_j = this.diseaseIdToIndexMap.get(j);
                if (index_i == null) {
                    this.LOGGER.error("Could not retrieve index for disease " + i.getValue());
                    continue;
                }
                if (index_j == null) {
                    this.LOGGER.error("Could not retrieve index for disease " + j.getValue());
                }
                if (!((s = this.similarityScores[index_i][index_j]) > max)) continue;
                max = s;
            }
        }
        return max;
    }

    private void performGeneBasedAnalysis() throws IOException {
        HpoDiseases diseases = HpoDiseaseLoaders.defaultLoader((MinimalOntology)this.hpo, (HpoDiseaseLoaderOptions)HpoDiseaseLoaderOptions.defaultOptions()).load(this.pathPhenotypeHpoa);
        HpoAssociationData hpoAssociationData = HpoAssociationData.builder((MinimalOntology)this.hpo).homoSapiensGeneInfo(this.geneInfoPath, GeneInfoGeneType.DEFAULT).mim2GeneMedgen(this.mimgeneMedgenPath).hpoDiseases((AnnotatedItemContainer)diseases).build();
        this.geneToDiseaseMap = hpoAssociationData.associations().geneIdToDiseaseIds();
        System.out.println("[INFO] geneToDiseaseMap with " + this.geneToDiseaseMap.size() + " entries");
        this.geneIdToSymbolMap = hpoAssociationData.geneIdToSymbol();
        System.out.println("[INFO] geneIdToSymbolMap with " + this.geneIdToSymbolMap.size() + " entries");
        ArrayList<TermId> geneList = new ArrayList<TermId>(this.geneToDiseaseMap.keySet());
        int N = geneList.size();
        double[][] geneSimilarityMatrix = new double[N][N];
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < N - 1; ++i) {
            for (int j = i; j < N; ++j) {
                try {
                    double sim;
                    TermId geneI = (TermId)geneList.get(i);
                    TermId geneJ = (TermId)geneList.get(j);
                    if (geneI == null) {
                        System.err.println("gene i was null=" + i);
                        continue;
                    }
                    if (geneJ == null) {
                        System.err.println("gene j was null=" + j);
                        continue;
                    }
                    if (i > this.n_diseases) {
                        System.err.printf("i=%d but n_diseases=%d\n", i, this.n_diseases);
                        continue;
                    }
                    if (j > this.n_diseases) {
                        System.err.printf("j=%d but n_diseases=%d\n", j, this.n_diseases);
                        continue;
                    }
                    geneSimilarityMatrix[i][j] = sim = this.getMaximumGeneGeneSimilarity(geneI, geneJ);
                    geneSimilarityMatrix[j][i] = sim;
                    stats.addValue(sim);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("i=" + i + ", j=" + j + " " + e.getMessage());
                }
            }
        }
        double mean = stats.getMean();
        double sd = stats.getSd();
        System.out.println("\n\n[INFO] Done calculating gene based similarity matrix. Mean=" + mean + ", sd=" + sd);
        double threshold = mean + 2.0 * sd;
        System.out.println("[INFO] Writing pairwise gene similarity to file.");
        int aboveThreshold = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFilename, new OpenOption[0]);){
            CharSequence[] fields = new String[]{"gene1", "symbol1", "gene2", "symbol2", "similarity"};
            String header = String.join((CharSequence)"\t", fields);
            writer.write(header + "\n");
            for (int i = 0; i < N - 1; ++i) {
                for (int j = i + 1; j < N; ++j) {
                    if (!(geneSimilarityMatrix[i][j] > threshold)) continue;
                    TermId geneId1 = (TermId)geneList.get(i);
                    TermId geneId2 = (TermId)geneList.get(j);
                    String g1 = geneId1.getValue();
                    String g2 = ((TermId)geneList.get(j)).getValue();
                    String symbol1 = this.geneIdToSymbolMap.get(geneId1);
                    String symbol2 = this.geneIdToSymbolMap.get(geneId2);
                    writer.write(g1 + "\t" + symbol1 + "\t" + g2 + "\t" + symbol2 + "\t" + geneSimilarityMatrix[i][j] + "\n");
                    ++aboveThreshold;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("[INFO] skipped vales: %d, good values %d\n", stats.skippedNanValue, stats.goodValue);
        System.out.printf("[INFO] Wrote %d above threshold (%.3f) pairwise interactions.\n", aboveThreshold, threshold);
    }

    private void performDiseaseBasedAnalysis(DescriptiveStatistics stats) {
        double mean = stats.getMean();
        double sd = stats.getSd();
        System.out.println("\n\nMean=" + mean + ", sd=" + sd);
        double threshold = mean + 2.0 * sd;
        System.out.println("[INFO] Writing pairwise phenotype similarity to file.");
        int aboveThreshold = 0;
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.outputFilename, new OpenOption[0]);
            CharSequence[] fields = new String[]{"disease1", "disease2", "similarity"};
            String header = String.join((CharSequence)"\t", fields);
            writer.write(header + "\n");
            int N = this.diseaseList.size();
            for (int i = 0; i < N - 1; ++i) {
                for (int j = i + 1; j < N; ++j) {
                    if (!(this.similarityScores[i][j] > threshold)) continue;
                    String d1 = this.diseaseList.get(i).id().getValue();
                    String d2 = this.diseaseList.get(j).id().getValue();
                    writer.write(d1 + "\t" + d2 + "\t" + this.similarityScores[i][j] + "\n");
                    ++aboveThreshold;
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("[INFO] Wrote %d above threshold (%.3f) pairwise interactions.\n", aboveThreshold, threshold);
    }

    public void run() throws IOException {
        if (this.pathHpObo == null || this.pathPhenotypeHpoa == null) {
            System.err.println("[ERROR] Must pass path-to-hp.obo and path-to-phenotype.hpoa");
            System.exit(1);
        }
        this.hpo = OntologyLoader.loadOntology((File)this.pathHpObo.toFile());
        System.out.println("[INFO] DONE: Loading HPO");
        HpoDiseaseLoader loader = HpoDiseaseLoaders.defaultLoader((MinimalOntology)this.hpo, (HpoDiseaseLoaderOptions)HpoDiseaseLoaderOptions.of(Set.of(DiseaseDatabase.OMIM), (boolean)true, (int)5));
        HpoDiseases hpoDiseases = loader.load(this.pathPhenotypeHpoa);
        this.diseaseMap = hpoDiseases.diseaseById();
        System.out.println("[INFO] DONE: Loading phenotype.hpoa");
        HashMap diseaseIdToTermIds = new HashMap();
        HashMap termIdToDiseaseIds = new HashMap();
        for (TermId diseaseId : this.diseaseMap.keySet()) {
            HpoDisease disease = this.diseaseMap.get(diseaseId);
            List hpoTerms = disease.annotationTermIds().collect(Collectors.toList());
            diseaseIdToTermIds.putIfAbsent(diseaseId, new HashSet());
            Set inclAncestorTermIds = TermIds.augmentWithAncestors((Ontology)this.hpo, new HashSet(hpoTerms), (boolean)true);
            for (TermId tid : inclAncestorTermIds) {
                termIdToDiseaseIds.putIfAbsent(tid, new HashSet());
                ((Collection)termIdToDiseaseIds.get(tid)).add(diseaseId);
                ((Collection)diseaseIdToTermIds.get(diseaseId)).add(tid);
            }
        }
        System.out.println("[INFO] Performing IC precomputation...");
        Map icMap = new InformationContentComputation((MinimalOntology)this.hpo).computeInformationContent(termIdToDiseaseIds);
        System.out.println("[INFO] DONE: Performing IC precomputation");
        System.out.println("[INFO] Performing Resnik precomputation...");
        PrecomputingPairwiseResnikSimilarity pairwiseResnikSimilarity = new PrecomputingPairwiseResnikSimilarity((MinimalOntology)this.hpo, icMap);
        System.out.println("[INFO] DONE: Performing Resnik precomputation");
        this.resnikSimilarity = new ResnikSimilarity((PairwiseSimilarity)pairwiseResnikSimilarity, false);
        System.out.printf("name: %s  params %s\n", this.resnikSimilarity.getName(), this.resnikSimilarity.getParameters());
        System.out.println("[INFO] Calculating pairwise phenotype similarity for " + this.diseaseMap.size() + " diseases.");
        this.diseaseList = new ArrayList<HpoDisease>(this.diseaseMap.values());
        this.diseaseIdToIndexMap = new HashMap<TermId, Integer>();
        for (int i = 0; i < this.diseaseList.size(); ++i) {
            this.diseaseIdToIndexMap.put(this.diseaseList.get(i).id(), i);
        }
        this.n_diseases = this.diseaseList.size();
        int expectedTotal = this.n_diseases * (this.n_diseases - 1) / 2;
        this.similarityScores = new double[this.n_diseases][this.n_diseases];
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int c = 0;
        for (int i = 0; i < this.n_diseases; ++i) {
            for (int j = i; j < this.n_diseases; ++j) {
                double similarity;
                HpoDisease d1 = this.diseaseList.get(i);
                HpoDisease d2 = this.diseaseList.get(j);
                List pheno1 = d1.annotationTermIds().collect(Collectors.toList());
                List pheno2 = d2.annotationTermIds().collect(Collectors.toList());
                this.similarityScores[i][j] = similarity = this.resnikSimilarity.computeScore(pheno1, pheno2);
                this.similarityScores[j][i] = similarity;
                stats.addValue(similarity);
                if (++c % 10000 != 0) continue;
                System.out.printf("Got %d/%d similarity counts (%.1f%%)\r", c, expectedTotal, 100.0 * (double)c / (double)expectedTotal);
            }
        }
        System.out.printf("[INFO] Disease analysis: skipped vales: %d, good values %d\n", stats.skippedNanValue, stats.goodValue);
        if (this.doGeneBasedAnalysis) {
            this.performGeneBasedAnalysis();
        } else {
            this.performDiseaseBasedAnalysis(stats);
        }
    }

    static class DescriptiveStatistics {
        List<Double> vals = new ArrayList<Double>();
        Double mean = null;
        Double sd = null;
        public int skippedNanValue = 0;
        public int goodValue = 0;

        DescriptiveStatistics() {
        }

        void addValue(double v) {
            if (Double.isNaN(v)) {
                ++this.skippedNanValue;
                return;
            }
            ++this.goodValue;
            this.vals.add(v);
        }

        double getMean() {
            double sum = 0.0;
            for (double d : this.vals) {
                sum += d;
            }
            this.mean = sum / (double)this.vals.size();
            return this.mean;
        }

        double getSd() {
            if (this.mean == null) {
                this.getMean();
            }
            double m = this.mean;
            double sumOfSquares = 0.0;
            for (double d : this.vals) {
                sumOfSquares += (d - m) * (d - m);
            }
            this.sd = Math.sqrt(1.0 / (double)this.vals.size() * sumOfSquares);
            return this.sd;
        }
    }
}

