/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.TermAssociationContainer;
import org.monarchinitiative.phenol.analysis.stats.GoTerm2PValAndCounts;
import org.monarchinitiative.phenol.analysis.stats.TermForTermPValueCalculation;
import org.monarchinitiative.phenol.analysis.stats.mtc.Bonferroni;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpAnnotation;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpGeneModel;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpGeneticMarker;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpoGeneAnnotation;
import org.monarchinitiative.phenol.annotations.obo.mpo.MpAnnotationParser;
import org.monarchinitiative.phenol.annotations.obo.mpo.MpGeneParser;
import org.monarchinitiative.phenol.io.MinimalOntologyLoader;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpEnrichmentDemo {
    private final MinimalOntology ontology;
    private final Map<TermId, MpGeneModel> mpgenemap;
    private Map<String, TermId> symbol2termidMap;
    private final Map<TermId, MpGeneticMarker> markermap;
    private final String targetgenefile;

    public MpEnrichmentDemo(String mpPath, String MGIgenePhenoPath, String targetGeneFile, String markerFile) {
        this.targetgenefile = targetGeneFile;
        this.mpgenemap = MpAnnotationParser.loadMpGeneModels((String)MGIgenePhenoPath);
        this.markermap = MpGeneParser.loadMarkerMap((String)markerFile);
        System.out.println("[INFO] parsed " + this.markermap.size() + " MP markers.");
        System.out.println("[INFO] parsed " + this.mpgenemap.size() + " MP gene models.");
        this.ontology = MinimalOntologyLoader.loadOntology((File)new File(mpPath));
        System.out.println("[INFO] Parsed phenotyped info associated with " + this.mpgenemap.size() + " genes.");
    }

    private List<TermAnnotation> getTermAnnotations() {
        ArrayList<MpoGeneAnnotation> builder = new ArrayList<MpoGeneAnnotation>();
        for (MpGeneModel model : this.mpgenemap.values()) {
            TermId markerId = model.getMarkerId();
            String symbol = this.markermap.containsKey(markerId) ? this.markermap.get(markerId).getGeneSymbol() : "n/a";
            for (MpAnnotation annot : model.getPhenotypicAbnormalities()) {
                TermId mpId = annot.getTermId();
                if (mpId == null) {
                    System.err.println("[ERROR] mp term id was null");
                }
                try {
                    String label = this.ontology.termForTermId(mpId).map(Term::getName).orElse(null);
                    MpoGeneAnnotation mpoGeneAnnotation = new MpoGeneAnnotation(markerId, symbol, label, mpId);
                    builder.add(mpoGeneAnnotation);
                }
                catch (Exception e) {
                    System.err.println("[ERROR] copuld not find term for " + String.valueOf(mpId));
                }
            }
        }
        return List.copyOf(builder);
    }

    public void run() {
        int n_terms = this.ontology.allTermIdCount();
        System.out.println("[INFO] parsed " + n_terms + " MP terms.");
        List<TermAnnotation> annots = this.getTermAnnotations();
        System.out.println("[INFO] parsed " + annots.size() + " MP annotations.");
        TermAssociationContainer associationContainer = TermAssociationContainer.fromGoTermAnnotations(annots, (MinimalOntology)this.ontology);
        Set<TermId> populationGenes = this.getPopulationSet(annots);
        System.out.println("[INFO] size of population set: " + populationGenes.size());
        Set<TermId> studyGenes = this.getStudySet();
        Map studyAssociations = associationContainer.getAssociationMap(studyGenes);
        StudySet studySet = new StudySet("study", studyAssociations);
        Map popAssociations = associationContainer.getAssociationMap(populationGenes);
        StudySet populationSet = new StudySet("population", popAssociations);
        System.out.printf("[INFO] study: %d genes, population: %d genes\n", studyGenes.size(), populationGenes.size());
        Bonferroni bonf = new Bonferroni();
        TermForTermPValueCalculation tftpvalcal = new TermForTermPValueCalculation(this.ontology, populationSet, studySet, (MultipleTestingCorrection)bonf);
        int popsize = populationGenes.size();
        int studysize = studyGenes.size();
        List pvals = tftpvalcal.calculatePVals();
        System.err.println("Total number of retrieved p values: " + pvals.size());
        int n_sig = 0;
        double ALPHA = 0.05;
        System.out.println("MPO TFT Enrichment");
        System.out.printf("Study set: %d genes. Population set: %d genes\n", studysize, popsize);
        for (GoTerm2PValAndCounts item : pvals) {
            double pval = item.getRawPValue();
            double pval_adj = item.getAdjustedPValue();
            TermId tid = item.getItem();
            Optional term = this.ontology.termForTermId(tid);
            if (term.isEmpty()) {
                System.err.println("[ERROR] Could not retrieve term for " + tid.getValue());
                continue;
            }
            String label = ((Term)term.get()).getName();
            if (pval_adj > ALPHA) continue;
            ++n_sig;
            double studypercentage = 100.0 * (double)item.getAnnotatedStudyGenes() / (double)studysize;
            double poppercentage = 100.0 * (double)item.getAnnotatedPopulationGenes() / (double)popsize;
            System.out.printf("%s [%s]: %.2e (adjusted %.2e). Study: n=%d/%d (%.1f%%); population: N=%d/%d (%.1f%%)\n", label, tid.getValue(), pval, pval_adj, item.getAnnotatedStudyGenes(), studysize, studypercentage, item.getAnnotatedPopulationGenes(), popsize, poppercentage);
        }
        System.out.printf("%d of %d terms were significant at alpha %.7f\n", n_sig, pvals.size(), ALPHA);
    }

    private void initSymbol2termidMap() {
        this.symbol2termidMap = new HashMap<String, TermId>();
        for (MpGeneticMarker gene : this.markermap.values()) {
            String symbol = gene.getGeneSymbol();
            TermId id = gene.getMgiGeneId();
            this.symbol2termidMap.put(symbol, id);
        }
    }

    private Set<TermId> getStudySet() {
        this.initSymbol2termidMap();
        HashSet<TermId> builder = new HashSet<TermId>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.targetgenefile));
            while ((line = br.readLine()) != null) {
                if (!this.symbol2termidMap.containsKey(line.trim())) continue;
                TermId id = this.symbol2termidMap.get(line.trim());
                builder.add(id);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Set.copyOf(builder);
    }

    private Set<TermId> getPopulationSet(List<TermAnnotation> annots) {
        HashSet<TermId> st = new HashSet<TermId>();
        for (TermAnnotation ann : annots) {
            TermId geneId = ann.getItemId();
            st.add(geneId);
        }
        return Set.copyOf(st);
    }
}

