/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.ontology.data.Dbxref;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MondoDemo {
    private final String mondoPath;
    private final String outPath;
    private MinimalOntology mondo;
    private List<Term> phenoseriesRoots;
    private Map<Term, Collection<TermId>> phenoseries2omimMap;

    public MondoDemo(String mondoPath, String out) {
        this.mondoPath = mondoPath;
        this.outPath = out;
        this.phenoseriesRoots = new ArrayList<Term>();
        this.phenoseries2omimMap = new HashMap<Term, Collection<TermId>>();
    }

    private boolean isOmimEntry(Term term) {
        for (Dbxref xref : term.getXrefs()) {
            if (!xref.getName().startsWith("OMIM")) continue;
            return true;
        }
        return false;
    }

    private Optional<TermId> getOMIMid(Term term) {
        for (Dbxref xref : term.getXrefs()) {
            if (!xref.getName().startsWith("OMIM") || xref.getName().startsWith("OMIMPS")) continue;
            return Optional.of(TermId.of((String)xref.getName()));
        }
        return Optional.empty();
    }

    public void run() {
        File file = new File(this.mondoPath);
        if (!file.exists()) {
            System.err.print("[ERROR] Could not find mondo.obo at " + this.mondoPath);
            return;
        }
        this.mondo = OntologyLoader.loadOntology((File)file);
        for (Term term : this.mondo.getTerms()) {
            for (Dbxref xref : term.getXrefs()) {
                if (!xref.getName().startsWith("OMIMPS")) continue;
                this.phenoseriesRoots.add(term);
            }
        }
        for (Term psterm : this.phenoseriesRoots) {
            for (TermId member : this.mondo.graph().getDescendants((Object)psterm.id(), true)) {
                Optional candidate = this.mondo.termForTermId(member);
                if (!candidate.isPresent() || !this.isOmimEntry((Term)candidate.get())) continue;
                this.phenoseries2omimMap.computeIfAbsent(psterm, key -> new HashSet()).add(((Term)candidate.get()).id());
            }
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.outPath));
            for (Term psterm : this.phenoseries2omimMap.keySet()) {
                Collection<TermId> coll = this.phenoseries2omimMap.get(psterm);
                for (TermId tid : coll) {
                    Optional<TermId> omimIdopt;
                    Optional omimentry = this.mondo.termForTermId(tid);
                    if (omimentry.isEmpty() || !(omimIdopt = this.getOMIMid((Term)omimentry.get())).isPresent()) continue;
                    TermId omimId = omimIdopt.get();
                    String line = psterm.id().getValue() + "\t" + psterm.getName() + "\t" + omimId.getValue() + "\t" + ((Term)omimentry.get()).getName();
                    System.out.println(line);
                    writer.write(line + "\n");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

