/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItem;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItemContainer;
import org.monarchinitiative.phenol.cli.demo.MicaData;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicaCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicaCalculator.class);
    private final MinimalOntology hpo;
    private final boolean assumeAnnotated;

    public MicaCalculator(MinimalOntology hpo, boolean assumeAnnotated) {
        this.assumeAnnotated = assumeAnnotated;
        this.hpo = Objects.requireNonNull(hpo);
    }

    public MicaData calculateMica(AnnotatedItemContainer<? extends AnnotatedItem> itemContainer) {
        Instant start = Instant.now();
        HashMap<TermId, Integer> phenotypeIdToDiseaseIds = new HashMap<TermId, Integer>();
        HashMap<TermId, Collection<TermId>> diseaseIdToTermIds = new HashMap<TermId, Collection<TermId>>();
        HashSet termsAndAncestorsBuilder = new HashSet();
        for (AnnotatedItem item : itemContainer) {
            for (Identified annotation : item.annotations()) {
                this.hpo.graph().extendWithAncestors((Object)annotation.id(), true, termsAndAncestorsBuilder);
            }
            for (TermId tid : termsAndAncestorsBuilder) {
                phenotypeIdToDiseaseIds.compute(tid, (key, val) -> val == null ? 0 : val + 1);
                diseaseIdToTermIds.computeIfAbsent(item.id(), key -> new HashSet()).add(tid);
            }
            termsAndAncestorsBuilder.clear();
        }
        HashMap<TermId, Double> termToIc = new HashMap<TermId, Double>();
        double totalPopulationHpoTerms = ((Integer)phenotypeIdToDiseaseIds.get(HpoSubOntologyRootTermIds.PHENOTYPIC_ABNORMALITY)).intValue();
        for (Map.Entry e : phenotypeIdToDiseaseIds.entrySet()) {
            int annotatedCount = this.assumeAnnotated ? Math.max((Integer)e.getValue(), 1) : (Integer)e.getValue();
            double ic = Math.log(totalPopulationHpoTerms / (double)annotatedCount);
            termToIc.put((TermId)e.getKey(), ic);
        }
        Duration duration = Duration.between(start, Instant.now());
        long seconds = duration.toMillis() / 1000L;
        double ms = (double)duration.toMillis() % 1000.0;
        LOGGER.debug("Calculated information content in {}s {}us", (Object)seconds, (Object)ms);
        return new MicaData(diseaseIdToTermIds, phenotypeIdToDiseaseIds, termToIc);
    }
}

