/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaders;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermXref;

public class HpDemo {
    private final String hpoPath;
    private final String annotPath;

    public HpDemo(String hpoPath, String annotPath) {
        this.hpoPath = hpoPath;
        this.annotPath = annotPath;
    }

    public void run() throws IOException {
        Ontology hpo = OntologyLoader.loadOntology((File)new File(this.hpoPath));
        TermId rootTermId = hpo.getRootTermId();
        String rootLabel = hpo.termForTermId(rootTermId).map(Term::getName).orElse(null);
        System.out.println("root term: " + rootLabel + " (" + rootTermId.getValue() + ")");
        TermId tid = TermId.of((String)"HP:0001807");
        Optional ridgedNail = hpo.termForTermId(tid);
        System.out.println("Data contained in term: " + (String)ridgedNail.map(Term::getName).orElse(null) + " (" + tid.getValue() + ")");
        String definition = ridgedNail.map(Term::getDefinition).orElse(null);
        System.out.println("Definition: " + definition);
        List synonyms = ridgedNail.map(Term::getSynonyms).orElse(List.of());
        System.out.println("Synonyms:");
        for (Object syn : synonyms) {
            String val = syn.getValue();
            String scope = syn.getScope().name();
            List xrefs = syn.getTermXrefs();
            String xrefstring = xrefs.stream().map(TermXref::getDescription).collect(Collectors.joining("; "));
            System.out.println("\tval:" + val + ", scope: " + (String)scope + ", xrefs: " + xrefstring);
        }
        System.out.println("Alternative IDs:");
        List alternateIds = ridgedNail.map(Term::getAltTermIds).orElse(List.of());
        for (TermId altId : alternateIds) {
            System.out.println("\t" + altId.getValue());
        }
        String comment = ridgedNail.map(Term::getComment).orElse(null);
        System.out.println("Comment: " + comment);
        List xrefs = ridgedNail.map(Term::getXrefs).orElse(List.of());
        System.out.println("Cross references:");
        for (Object xref : xrefs) {
            System.out.println("\t" + xref.getName());
        }
        System.out.println("Database Cross references:");
        List databaseXrefs = ridgedNail.map(Term::getDatabaseXrefs).orElse(List.of());
        for (Object dbxref : databaseXrefs) {
            System.out.println("\t" + dbxref.toString());
        }
        List pmids = ridgedNail.map(Term::getPmidXrefs).orElse(List.of());
        System.out.println("PubMed ids:");
        for (Object pmid : pmids) {
            System.out.println("\t" + pmid.toString());
        }
        List subsets = ridgedNail.map(Term::getSubsets).orElse(List.of());
        System.out.println("Subsets:");
        for (String sset : subsets) {
            System.out.println("\t" + sset);
        }
        HpoDiseaseLoader loader = HpoDiseaseLoaders.defaultLoader((MinimalOntology)hpo, (HpoDiseaseLoaderOptions)HpoDiseaseLoaderOptions.of(Set.of(DiseaseDatabase.OMIM, DiseaseDatabase.ORPHANET, DiseaseDatabase.DECIPHER), (boolean)true, (int)5));
        HpoDiseases hpoDiseases = loader.load(Paths.get(this.annotPath, new String[0]));
        System.out.println("Imported " + hpoDiseases.size() + " disease models");
    }
}

