/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.demo;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.GoAssociationContainer;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.mgsa.MgsaCalculation;
import org.monarchinitiative.phenol.analysis.mgsa.MgsaGOTermsResultContainer;
import org.monarchinitiative.phenol.analysis.stats.GoTerm2PValAndCounts;
import org.monarchinitiative.phenol.analysis.stats.ParentChildIntersectionPValueCalculation;
import org.monarchinitiative.phenol.analysis.stats.TermForTermPValueCalculation;
import org.monarchinitiative.phenol.analysis.stats.mtc.Bonferroni;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;
import org.monarchinitiative.phenol.annotations.formats.go.GoGaf22Annotation;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;
import picocli.CommandLine;

@CommandLine.Command(name="download", aliases={"D"}, mixinStandardHelpOptions=true, description={"Download files for fenominal"})
public final class GoEnrichmentDemo {
    private final TermId targetGoTerm;
    private final Ontology gontology;
    private final List<GoGaf22Annotation> goAnnots;
    private final Set<TermId> populationGenes;
    private final StudySet studySet;
    private final StudySet populationSet;
    private final int popsize;
    private final int studysize;
    private final GoAssociationContainer associationContainer;
    private static final double ALPHA = 0.05;
    private static final int STUDYSET_SIZE = 400;

    public GoEnrichmentDemo(String pathGoObo, String pathGoGaf, String goTermId) {
        this.targetGoTerm = TermId.of((String)goTermId);
        System.out.println("[INFO] parsing  " + pathGoObo);
        this.gontology = OntologyLoader.loadOntology((File)new File(pathGoObo), (String[])new String[]{"GO"});
        int n_terms = this.gontology.allTermIdCount();
        System.out.println("[INFO] parsed " + n_terms + " GO terms.");
        Path goGaf = Paths.get(pathGoGaf, new String[0]);
        System.out.println("[INFO] parsing  " + String.valueOf(goGaf.toAbsolutePath()));
        this.associationContainer = GoAssociationContainer.loadGoGafAssociationContainer((Path)goGaf, (Ontology)this.gontology);
        this.goAnnots = this.associationContainer.getRawAssociations();
        this.populationGenes = this.getPopulationGenes(this.goAnnots);
        Set<TermId> studyGenes = this.getFocusedStudyGenes(this.goAnnots, this.targetGoTerm);
        Map studyAssociations = this.associationContainer.getAssociationMap(studyGenes);
        this.studySet = this.associationContainer.fromGeneIds(studyGenes, "study");
        Map populationAssociations = this.associationContainer.getAssociationMap(this.populationGenes);
        this.populationSet = this.associationContainer.fromGeneIds(this.populationGenes, "population");
        this.popsize = this.populationGenes.size();
        this.studysize = studyGenes.size();
    }

    private void performMgsaAnalysis() {
        System.out.println();
        System.out.println("[INFO] Demo: MGSA analysis");
        System.out.println();
        int mcmcSteps = 500000;
        MgsaCalculation mgsa = new MgsaCalculation(this.gontology, this.associationContainer, mcmcSteps);
        MgsaGOTermsResultContainer result = mgsa.calculateStudySet(this.studySet);
        result.dumpToShell();
    }

    private void performTermForTermAnalysis() {
        System.out.println();
        System.out.println("[INFO] Demo: Term-for-term analysis");
        System.out.println();
        Bonferroni bonf = new Bonferroni();
        TermForTermPValueCalculation tftpvalcal = new TermForTermPValueCalculation((MinimalOntology)this.gontology, this.populationSet, this.studySet, (MultipleTestingCorrection)bonf);
        List pvals = tftpvalcal.calculatePVals();
        System.out.println("[INFO] Total number of retrieved p values: " + pvals.size());
        int n_sig = 0;
        System.out.printf("[INFO] Target term %s [%s]\n", this.gontology.termForTermId(this.targetGoTerm).map(Term::getName).orElse(null), this.targetGoTerm.getValue());
        System.out.printf("[INFO] Study set: %d genes. Population set: %d genes\n", this.studysize, this.popsize);
        for (GoTerm2PValAndCounts item : pvals) {
            double pval = item.getRawPValue();
            double pval_adj = item.getAdjustedPValue();
            TermId tid = item.getItem();
            Optional term = this.gontology.termForTermId(tid);
            if (term.isEmpty()) {
                System.err.println("[ERROR] Could not retrieve term for " + tid.getValue());
                continue;
            }
            String label = ((Term)term.get()).getName();
            if (pval_adj > 0.05) continue;
            ++n_sig;
            double studypercentage = 100.0 * (double)item.getAnnotatedStudyGenes() / (double)this.studysize;
            double poppercentage = 100.0 * (double)item.getAnnotatedPopulationGenes() / (double)this.popsize;
            System.out.printf("%s [%s]: %.2e (adjusted %.2e). Study: n=%d (%.1f%%); population: N=%d (%.1f%%)\n", label, tid.getValue(), pval, pval_adj, item.getAnnotatedStudyGenes(), studypercentage, item.getAnnotatedPopulationGenes(), poppercentage);
        }
        System.out.printf("%d of %d terms were significant at alpha %.7f\n", n_sig, pvals.size(), 0.05);
    }

    private void performParentChildIntersectionAnalysis() {
        System.out.println();
        System.out.println("[INFO] Demo: parent child intersection analysis");
        System.out.println();
        Bonferroni bonf = new Bonferroni();
        ParentChildIntersectionPValueCalculation pcPvalCalc = new ParentChildIntersectionPValueCalculation(this.gontology, this.populationSet, this.studySet, (MultipleTestingCorrection)bonf);
        List pvals = pcPvalCalc.calculatePVals();
        System.err.println("Total number of retrieved p values: " + pvals.size());
        int n_sig = 0;
        System.out.printf("GO Parent Child Intersection Enrichment Demo for target term %s [%s]\n", this.gontology.termForTermId(this.targetGoTerm).map(Term::getName).orElse(null), this.targetGoTerm.getValue());
        System.out.printf("Study set: %d genes. Population set: %d genes\n", this.studysize, this.popsize);
        for (GoTerm2PValAndCounts item : pvals) {
            double pval = item.getRawPValue();
            double pval_adj = item.getAdjustedPValue();
            TermId tid = item.getItem();
            Optional term = this.gontology.termForTermId(tid);
            if (term.isEmpty()) {
                System.err.println("[ERROR] Could not retrieve term for " + tid.getValue());
                continue;
            }
            String label = ((Term)term.get()).getName();
            if (pval_adj > 0.05) continue;
            ++n_sig;
            double studypercentage = 100.0 * (double)item.getAnnotatedStudyGenes() / (double)this.studysize;
            double poppercentage = 100.0 * (double)item.getAnnotatedPopulationGenes() / (double)this.popsize;
            System.out.printf("PCI: %s [%s]: %.2e (adjusted %.2e). Study: n=%d (%.1f%%); population: N=%d (%.1f%%)\n", label, tid.getValue(), pval, pval_adj, item.getAnnotatedStudyGenes(), studypercentage, item.getAnnotatedPopulationGenes(), poppercentage);
        }
        System.out.printf("PCI: %d of %d terms were significant at alpha %.7f\n", n_sig, pvals.size(), 0.05);
    }

    private Set<TermId> getFocusedStudyGenes(List<GoGaf22Annotation> annots, TermId focus) {
        return this.getFocusedStudyGenes(annots, focus, 0.5);
    }

    private Set<TermId> getFocusedStudyGenes(List<GoGaf22Annotation> annots, TermId focus, double proportion) {
        HashSet<TermId> targetGenes = new HashSet<TermId>();
        for (TermAnnotation termAnnotation : annots) {
            if (!focus.equals((Object)termAnnotation.id())) continue;
            TermId geneId = termAnnotation.getItemId();
            targetGenes.add(geneId);
        }
        int N = targetGenes.size();
        System.out.printf("[INFO] Genes annotated to %s: n=%d\n", focus.getValue(), N);
        int n = (int)(proportion * (double)N / 2.0);
        HashSet<TermId> finalGenes = new HashSet<TermId>();
        int i = 0;
        for (TermId termId : targetGenes) {
            if (i++ > n) break;
            finalGenes.add(termId);
        }
        for (TermAnnotation termAnnotation : annots) {
            TermId gene = termAnnotation.getItemId();
            if (!targetGenes.contains(gene)) {
                finalGenes.add(gene);
            }
            if (finalGenes.size() <= 400) continue;
            break;
        }
        return Set.copyOf(finalGenes);
    }

    private Set<TermId> getPopulationGenes(List<GoGaf22Annotation> annots) {
        HashSet<TermId> st = new HashSet<TermId>();
        for (TermAnnotation termAnnotation : annots) {
            TermId geneId = termAnnotation.getItemId();
            st.add(geneId);
        }
        return Set.copyOf(st);
    }

    public void run() {
        System.out.println("[INFO] Target term: " + (String)this.gontology.termForTermId(this.targetGoTerm).map(Term::getName).orElse(null));
        this.performTermForTermAnalysis();
        this.performParentChildIntersectionAnalysis();
        this.performMgsaAnalysis();
    }
}

