/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.cli.cmd;

import java.util.concurrent.Callable;
import org.monarchinitiative.phenol.cli.demo.PrecomputeScores;
import picocli.CommandLine;

@CommandLine.Command(name="precompute", mixinStandardHelpOptions=true, description={"precompute scores"})
public class PrecomputeScoresCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-t", "--num-threads"}, description={"Number of threads to use."})
    public int numThreads = 1;
    @CommandLine.Option(names={"--min-num-terms"}, description={"Minimal number of terms to precompute for."})
    public int minNumTerms = 1;
    @CommandLine.Option(names={"--max-num-terms"}, description={"Maximal number of terms to precompute for."})
    public int maxNumTerms = 20;
    @CommandLine.Option(names={"--num-iterations"}, description={"Number of iterations to run."})
    public int numIterations = 10000;
    @CommandLine.Option(names={"--seed"}, description={"Seed to use for RNG."})
    public int seed = 42;
    @CommandLine.Option(names={"--input-obo-file"}, description={"Path to (HPO) OBO file to load."}, required=true)
    public String oboFile;
    @CommandLine.Option(names={"--gene-to-term-file"}, description={"Path to gene-to-term link file."}, required=true)
    public String geneToTermLinkFile;
    @CommandLine.Option(names={"--output-score-dist"}, description={"Path to output score distribution file"}, required=true)
    public String outputScoreDistFile;

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getMinNumTerms() {
        return this.minNumTerms;
    }

    public int getMaxNumTerms() {
        return this.maxNumTerms;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public int getSeed() {
        return this.seed;
    }

    public String getOboFile() {
        return this.oboFile;
    }

    public String getGeneToTermLinkFile() {
        return this.geneToTermLinkFile;
    }

    public String getOutputScoreDistFile() {
        return this.outputScoreDistFile;
    }

    public String toString() {
        return "PrecomputeScoresOptions [numThreads=" + this.numThreads + ", minNumTerms=" + this.minNumTerms + ", maxNumTerms=" + this.maxNumTerms + ", numIterations=" + this.numIterations + ", seed=" + this.seed + ", oboFile=" + this.oboFile + ", geneToTermLinkFile=" + this.geneToTermLinkFile + ", outputScoreDistFile=" + this.outputScoreDistFile + "]";
    }

    @Override
    public Integer call() {
        PrecomputeScores scores = new PrecomputeScores(this.oboFile, this.numIterations, this.seed, this.numThreads, this.outputScoreDistFile);
        scores.run();
        return 0;
    }
}

