/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.go;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.monarchinitiative.phenol.annotations.formats.go.GoGaf22Annotation;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GoGeneAnnotationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoGeneAnnotationParser.class);

    private GoGeneAnnotationParser() {
    }

    public static List<GoGaf22Annotation> loadAnnotations(Path path) {
        ArrayList<GoGaf22Annotation> goGaf22annots = new ArrayList<GoGaf22Annotation>();
        try (BufferedReader br = Files.newBufferedReader(path);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("!")) continue;
                try {
                    goGaf22annots.add(GoGaf22Annotation.parseAnnotation(line));
                }
                catch (PhenolException e) {
                    LOGGER.error("Could not parse GoGaf line ({}): {}", (Object)line, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Could not parse " + String.valueOf(path) + ": " + e.getMessage());
        }
        return List.copyOf(goGaf22annots);
    }

    @Deprecated(forRemoval=true)
    public static List<GoGaf22Annotation> loadTermAnnotations(File file) {
        return GoGeneAnnotationParser.loadAnnotations(file.toPath());
    }

    @Deprecated(forRemoval=true)
    public static List<TermAnnotation> loadTermAnnotations(Path path) {
        List<GoGaf22Annotation> annots = GoGeneAnnotationParser.loadAnnotations(path);
        return new ArrayList<TermAnnotation>(annots);
    }
}

