/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoClinicalModifierTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoFrequencyTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoOnsetTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModelException;
import org.monarchinitiative.phenol.annotations.hpo.ObsoleteTermIdRuntimeException;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class HpoAnnotationEntry {
    private static final Logger logger = LoggerFactory.getLogger(HpoAnnotationEntry.class);
    private static final Pattern RATIO_PATTERN = Pattern.compile("(?<numerator>\\d+)/(?<denominator>\\d+)");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile("(?<value>\\d+\\.?(\\d+)?)%");
    private static final String EMPTY_STRING = "";
    private final String diseaseID;
    private final String diseaseName;
    private final TermId phenotypeId;
    private final String phenotypeName;
    private final String ageOfOnsetId;
    private final String ageOfOnsetName;
    private final String evidenceCode;
    private final String frequencyModifier;
    private final String sex;
    private final String negation;
    private final String modifier;
    private final String description;
    private final String publication;
    private final String biocuration;
    private static final String[] expectedFields = new String[]{"#diseaseID", "diseaseName", "phenotypeID", "phenotypeName", "onsetID", "onsetName", "frequency", "sex", "negation", "modifier", "description", "publication", "evidence", "biocuration"};
    private static final int NUMBER_OF_FIELDS = expectedFields.length;
    private static final Set<String> validDatabases = Arrays.stream(DiseaseDatabase.values()).map(DiseaseDatabase::prefix).collect(Collectors.toUnmodifiableSet());
    private static final Set<TermId> frequencySubhierarchyTermIds = Set.of(HpoFrequencyTermIds.FREQUENCY, HpoFrequencyTermIds.OBLIGATE, HpoFrequencyTermIds.VERY_FREQUENT, HpoFrequencyTermIds.FREQUENT, HpoFrequencyTermIds.OCCASIONAL, HpoFrequencyTermIds.VERY_RARE, HpoFrequencyTermIds.EXCLUDED);
    private static final Set<TermId> onsetSubhierarchyTermIds = Set.of(HpoOnsetTermIds.ONSET, HpoOnsetTermIds.EMBRYONAL_ONSET, HpoOnsetTermIds.ADULT_ONSET, HpoOnsetTermIds.MIDDLE_AGE_ONSET, HpoOnsetTermIds.LATE_ONSET, HpoOnsetTermIds.YOUNG_ADULT_ONSET, HpoOnsetTermIds.CONGENITAL_ONSET, HpoOnsetTermIds.NEONATAL_ONSET, HpoOnsetTermIds.PEDIATRIC_ONSET, HpoOnsetTermIds.CHILDHOOD_ONSET, HpoOnsetTermIds.INFANTILE_ONSET, HpoOnsetTermIds.JUVENILE_ONSET, HpoOnsetTermIds.ANTENATAL_ONSET, HpoOnsetTermIds.FETAL_ONSET);
    private static final Set<String> EVIDENCE_CODES = Set.of("IEA", "TAS", "PCS");
    private static final Set<String> VALID_CITATION_PREFIXES = Set.of("PMID", "OMIM", "http", "https", "DECIPHER", "ORPHA", "ISBN", "ISBN-10", "ISBN-13");
    private static final String biocurationRegex = "(\\w+:\\w+)\\[(\\d{4}-\\d{2}-\\d{2})]";
    private static final Pattern biocurationPattern = Pattern.compile("(\\w+:\\w+)\\[(\\d{4}-\\d{2}-\\d{2})]");

    public String getDiseaseID() {
        return this.diseaseID;
    }

    public String getDB() {
        return TermId.of((String)this.diseaseID).getPrefix();
    }

    public String getDB_Object_ID() {
        return TermId.of((String)this.diseaseID).getId();
    }

    public String getDiseaseName() {
        return this.diseaseName;
    }

    public TermId getPhenotypeId() {
        return this.phenotypeId;
    }

    public String getPhenotypeLabel() {
        return this.phenotypeName;
    }

    public String getAgeOfOnsetId() {
        return this.ageOfOnsetId;
    }

    public String getAgeOfOnsetLabel() {
        return this.ageOfOnsetName != null ? this.ageOfOnsetName : EMPTY_STRING;
    }

    public String getEvidenceCode() {
        return this.evidenceCode;
    }

    public String getFrequencyModifier() {
        return this.frequencyModifier != null ? this.frequencyModifier : EMPTY_STRING;
    }

    public String getSex() {
        return this.sex != null ? this.sex : EMPTY_STRING;
    }

    public String getNegation() {
        return this.negation != null ? this.negation : EMPTY_STRING;
    }

    public String getModifier() {
        return this.modifier != null ? this.modifier : EMPTY_STRING;
    }

    public String getDescription() {
        return this.description != null ? this.modifier : EMPTY_STRING;
    }

    public String getPublication() {
        return this.publication;
    }

    public String getBiocuration() {
        return this.biocuration;
    }

    HpoAnnotationEntry(String disID, String diseaseName, TermId phenotypeId, String phenotypeName, String ageOfOnsetId, String ageOfOnsetName, String frequencyString, String sex, String negation, String modifier, String description, String publication, String evidenceCode, String biocuration) {
        this.diseaseID = disID;
        this.diseaseName = diseaseName;
        this.phenotypeId = phenotypeId;
        this.phenotypeName = phenotypeName;
        this.ageOfOnsetId = ageOfOnsetId;
        this.ageOfOnsetName = ageOfOnsetName;
        this.frequencyModifier = frequencyString;
        this.sex = sex;
        this.negation = negation;
        this.modifier = modifier;
        this.description = description;
        this.publication = publication;
        this.evidenceCode = evidenceCode;
        this.biocuration = biocuration;
    }

    public String toString() {
        return this.getRow();
    }

    public String getLineNoTabs() {
        return this.getRow().replaceAll("\\s+", " ");
    }

    public String getRow() {
        return String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s", this.diseaseID, this.diseaseName, this.phenotypeId.getValue(), this.phenotypeName, this.ageOfOnsetId != null ? this.ageOfOnsetId : EMPTY_STRING, this.ageOfOnsetName != null ? this.ageOfOnsetName : EMPTY_STRING, this.frequencyModifier != null ? this.frequencyModifier : EMPTY_STRING, this.sex != null ? this.sex : EMPTY_STRING, this.negation != null ? this.negation : EMPTY_STRING, this.modifier != null ? this.modifier : EMPTY_STRING, this.description != null ? this.description : EMPTY_STRING, this.publication != null ? this.publication : EMPTY_STRING, this.evidenceCode != null ? this.evidenceCode : EMPTY_STRING, this.biocuration != null ? this.biocuration : EMPTY_STRING);
    }

    public static HpoAnnotationEntry fromLine(String line, Ontology ontology) throws PhenolException {
        String[] A = line.split("\t");
        if (A.length != NUMBER_OF_FIELDS) {
            throw new HpoAnnotationModelException(String.format("We were expecting %d expectedFields but got %d for line %s", NUMBER_OF_FIELDS, A.length, line));
        }
        String diseaseID = A[0];
        String diseaseName = A[1];
        TermId phenotypeId = TermId.of((String)A[2]);
        String phenotypeName = A[3];
        String ageOfOnsetId = A[4];
        String ageOfOnsetName = A[5];
        String frequencyString = A[6];
        String sex = A[7];
        String negation = A[8];
        String modifier = A[9];
        String description = A[10];
        String publication = A[11];
        String evidenceCode = A[12];
        String biocuration = A[13];
        HpoAnnotationEntry entry = new HpoAnnotationEntry(diseaseID, diseaseName, phenotypeId, phenotypeName, ageOfOnsetId, ageOfOnsetName, frequencyString, sex, negation, modifier, description, publication, evidenceCode, biocuration);
        HpoAnnotationEntry.performQualityControl(entry, ontology);
        return entry;
    }

    public static Optional<HpoAnnotationEntry> fromLineReplaceObsoletePhenotypeData(String line, Ontology ontology) {
        String[] A = line.split("\t");
        if (A.length != NUMBER_OF_FIELDS) {
            return Optional.empty();
        }
        String diseaseID = A[0];
        String diseaseName = A[1];
        TermId phenotypeId = TermId.of((String)A[2]);
        String phenotypeName = A[3];
        TermId currentPhenotypeId = ontology.getPrimaryTermId(phenotypeId);
        if (currentPhenotypeId != null) {
            String currentLabel = ((Term)ontology.getTermMap().get(currentPhenotypeId)).getName();
            phenotypeId = currentPhenotypeId;
            phenotypeName = currentLabel;
        }
        String ageOfOnsetId = A[4];
        String ageOfOnsetName = A[5];
        String frequencyString = A[6];
        String sex = A[7];
        String negation = A[8];
        String modifier = A[9];
        String description = A[10];
        String publication = A[11];
        String evidenceCode = A[12];
        String biocuration = A[13];
        HpoAnnotationEntry entry = new HpoAnnotationEntry(diseaseID, diseaseName, phenotypeId, phenotypeName, ageOfOnsetId, ageOfOnsetName, frequencyString, sex, negation, modifier, description, publication, evidenceCode, biocuration);
        try {
            HpoAnnotationEntry.performQualityControl(entry, ontology);
        }
        catch (HpoAnnotationModelException e) {
            logger.warn(e.getMessage());
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    public static HpoAnnotationEntry fromOrphaData(String diseaseID, String diseaseName, String hpoId, String hpoLabel, TermId frequency, Ontology ontology, String biocuration, boolean replaceObsoleteTermId) throws HpoAnnotationModelException {
        String negationString;
        if (hpoId == null) {
            throw new HpoAnnotationModelException("Null String passed as hpoId for disease " + (diseaseID != null ? diseaseID : "n/a"));
        }
        TermId phenotypeId = TermId.of((String)hpoId);
        String frequencyString = frequency.equals((Object)HpoFrequencyTermIds.EXCLUDED) ? EMPTY_STRING : frequency.getValue();
        String string = negationString = frequency.equals((Object)HpoFrequencyTermIds.EXCLUDED) ? "NOT" : EMPTY_STRING;
        if (replaceObsoleteTermId) {
            String currentPhenotypeLabel;
            TermId currentPhenotypeId = ontology.getPrimaryTermId(phenotypeId);
            if (currentPhenotypeId != null && !currentPhenotypeId.equals((Object)phenotypeId)) {
                String newLabel = ((Term)ontology.getTermMap().get(phenotypeId)).getName();
                logger.warn("{}: Replacing obsolete TermId \"{}\" with current ID \"{}\" (and obsolete label {} with current label {})", new Object[]{diseaseID, hpoId, currentPhenotypeId.getValue(), hpoLabel, newLabel});
                phenotypeId = currentPhenotypeId;
                hpoLabel = newLabel;
            }
            if (currentPhenotypeId != null && (currentPhenotypeLabel = ((Term)ontology.getTermMap().get(phenotypeId)).getName()) != null && !hpoLabel.equals(currentPhenotypeLabel)) {
                logger.warn("{}: Replacing obsolete Term label \"{}\" with current label \"{}\"", new Object[]{diseaseID, hpoLabel, currentPhenotypeLabel});
                hpoLabel = currentPhenotypeLabel;
            }
        }
        HpoAnnotationEntry entry = new HpoAnnotationEntry(diseaseID, diseaseName, phenotypeId, hpoLabel, EMPTY_STRING, EMPTY_STRING, frequencyString, EMPTY_STRING, negationString, EMPTY_STRING, EMPTY_STRING, diseaseID, "TAS", biocuration);
        HpoAnnotationEntry.performQualityControl(entry, ontology);
        return entry;
    }

    public static HpoAnnotationEntry fromOrphaInheritanceData(String diseaseID, String diseaseName, TermId hpoInheritanceId, String hpoLabel, String biocuration) {
        String frequencyString = EMPTY_STRING;
        String negationString = EMPTY_STRING;
        return new HpoAnnotationEntry(diseaseID, diseaseName, hpoInheritanceId, hpoLabel, EMPTY_STRING, EMPTY_STRING, frequencyString, EMPTY_STRING, negationString, EMPTY_STRING, EMPTY_STRING, diseaseID, "TAS", biocuration);
    }

    private static void performQualityControl(HpoAnnotationEntry entry, Ontology ontology) throws HpoAnnotationModelException {
        HpoAnnotationEntry.checkDB(entry);
        HpoAnnotationEntry.checkDiseaseName(entry.getDiseaseName());
        HpoAnnotationEntry.checkPhenotypeFields(entry, ontology);
        HpoAnnotationEntry.checkAgeOfOnsetFields(entry.getAgeOfOnsetId(), entry.getAgeOfOnsetLabel(), ontology);
        HpoAnnotationEntry.checkFrequency(entry.getFrequencyModifier(), ontology);
        HpoAnnotationEntry.checkSexEntry(entry.getSex());
        HpoAnnotationEntry.checkNegation(entry.getNegation());
        HpoAnnotationEntry.checkModifier(entry.getModifier(), ontology);
        HpoAnnotationEntry.checkPublication(entry.getPublication());
        HpoAnnotationEntry.checkEvidence(entry.getEvidenceCode());
        HpoAnnotationEntry.checkBiocuration(entry.getBiocuration());
    }

    private static void checkDB(HpoAnnotationEntry entry) throws HpoAnnotationModelException {
        try {
            String db = entry.getDB();
            if (!validDatabases.contains(db)) {
                throw new HpoAnnotationModelException(String.format("Invalid database symbol: \"%s\"", db));
            }
        }
        catch (PhenolRuntimeException r) {
            throw new HpoAnnotationModelException("Could not construct database: " + r.getMessage());
        }
    }

    private static void checkDiseaseName(String name) throws HpoAnnotationModelException {
        if (name == null || name.isEmpty()) {
            throw new HpoAnnotationModelException("Missing disease name");
        }
    }

    private static void checkPhenotypeFields(HpoAnnotationEntry entry, Ontology ontology) throws HpoAnnotationModelException {
        TermId id = entry.getPhenotypeId();
        String termLabel = entry.getPhenotypeLabel();
        if (id == null) {
            throw new HpoAnnotationModelException("Phenotype id was for \"" + termLabel + "\"");
        }
        if (!ontology.getTermMap().containsKey(id)) {
            throw new HpoAnnotationModelException(String.format("Could not find HPO term id (\"%s\") for \"%s\"", id, termLabel));
        }
        TermId current = ((Term)ontology.getTermMap().get(id)).id();
        if (!current.equals((Object)id)) {
            throw new ObsoleteTermIdRuntimeException(String.format("Usage of (obsolete) alt_id %s for %s (%s)", id.getValue(), current.getValue(), ((Term)ontology.getTermMap().get(id)).getName()));
        }
        if (termLabel == null || termLabel.isEmpty()) {
            throw new HpoAnnotationModelException("Missing HPO term label for id=" + id.getValue());
        }
        String currentLabel = ((Term)ontology.getTermMap().get(id)).getName();
        if (!currentLabel.equals(termLabel)) {
            String errmsg = String.format("Wrong term label %s instead of %s for %s", termLabel, currentLabel, ((Term)ontology.getTermMap().get(id)).getName());
            throw new HpoAnnotationModelException(errmsg);
        }
    }

    private static void checkAgeOfOnsetFields(String id, String termLabel, Ontology ontology) throws HpoAnnotationModelException {
        if (id == null || id.isEmpty()) {
            if (termLabel != null && !termLabel.isEmpty()) {
                throw new HpoAnnotationModelException("Onset ID empty but Onset label present");
            }
            return;
        }
        TermId tid = TermId.of((String)id);
        if (!ontology.getTermMap().containsKey(tid)) {
            throw new HpoAnnotationModelException(String.format("Onset ID not found: \"%s\"", id));
        }
        TermId current = ((Term)ontology.getTermMap().get(tid)).id();
        if (!current.equals((Object)tid)) {
            throw new ObsoleteTermIdRuntimeException(String.format("Usage of (obsolete) alt_id %s for %s (%s)", tid.getValue(), current.getValue(), ((Term)ontology.getTermMap().get(tid)).getName()));
        }
        if (!onsetSubhierarchyTermIds.contains(tid)) {
            throw new HpoAnnotationModelException("Invalid ID in onset ID field: \"" + String.valueOf(tid) + "\"");
        }
        if (termLabel == null || termLabel.isEmpty()) {
            throw new HpoAnnotationModelException("Missing HPO term label for onset id=" + id);
        }
        String currentLabel = ((Term)ontology.getTermMap().get(tid)).getName();
        if (!currentLabel.equals(termLabel)) {
            String errmsg = String.format("Wrong onset term label %s instead of %s for %s", termLabel, currentLabel, ((Term)ontology.getTermMap().get(tid)).getName());
            throw new HpoAnnotationModelException(errmsg);
        }
    }

    private static void checkEvidence(String evi) throws HpoAnnotationModelException {
        if (!EVIDENCE_CODES.contains(evi)) {
            throw new HpoAnnotationModelException(String.format("Invalid evidence code: \"%s\"", evi));
        }
    }

    private static void checkFrequency(String freq, Ontology ontology) throws HpoAnnotationModelException {
        TermId id;
        if (freq == null || freq.isEmpty()) {
            return;
        }
        Matcher matcher = RATIO_PATTERN.matcher(freq);
        if (matcher.matches()) {
            int denominator;
            int numerator = Integer.parseInt(matcher.group("numerator"));
            if (numerator > (denominator = Integer.parseInt(matcher.group("denominator"))) || denominator == 0) {
                throw new HpoAnnotationModelException(String.format("Malformed frequency term: \"%s\"", freq));
            }
            return;
        }
        matcher = PERCENTAGE_PATTERN.matcher(freq);
        if (matcher.matches()) {
            float percent = Float.parseFloat(matcher.group("value"));
            if (percent > 100.0f || percent <= 0.0f) {
                throw new HpoAnnotationModelException(String.format("Malformed frequency term: \"%s\"", freq));
            }
            return;
        }
        if (!freq.matches("HP:\\d{7}")) {
            throw new HpoAnnotationModelException(String.format("Malformed frequency term: \"%s\"", freq));
        }
        try {
            id = TermId.of((String)freq);
        }
        catch (PhenolRuntimeException pre) {
            throw new HpoAnnotationModelException(String.format("Could not parse frequency term id: \"%s\"", freq));
        }
        if (!frequencySubhierarchyTermIds.contains(id)) {
            throw new HpoAnnotationModelException(String.format("Usage of incorrect term for frequency: %s [%s]", ((Term)ontology.getTermMap().get(id)).getName(), ((Term)ontology.getTermMap().get(id)).id().getValue()));
        }
    }

    private static void checkSexEntry(String sex) throws HpoAnnotationModelException {
        if (sex == null || sex.isEmpty()) {
            return;
        }
        if (!sex.equalsIgnoreCase("MALE") && !sex.equalsIgnoreCase("FEMALE")) {
            throw new HpoAnnotationModelException(String.format("Malformed sex entry: \"%s\"", sex));
        }
    }

    private static void checkNegation(String negation) throws HpoAnnotationModelException {
        if (negation != null && !negation.isEmpty() && !negation.equals("NOT")) {
            throw new HpoAnnotationModelException(String.format("Malformed negation entry: \"%s\"", negation));
        }
    }

    private static void checkModifier(String modifierString, Ontology ontology) throws HpoAnnotationModelException {
        String[] A;
        if (modifierString == null || modifierString.isEmpty()) {
            return;
        }
        TermId clinicalModifier = TermId.of((String)"HP:0012823");
        TermId temporalPattern = TermId.of((String)"HP:0011008");
        TermId paceOfProgression = TermId.of((String)"HP:0003679");
        for (String a : A = modifierString.split(";")) {
            try {
                TermId tid = TermId.of((String)a);
                Set ancs = ontology.getAncestorTermIds(tid);
                if (ancs.contains(clinicalModifier) || ancs.contains(temporalPattern) || ancs.contains(paceOfProgression)) continue;
                throw new HpoAnnotationModelException(String.format("Use of wrong HPO term in modifier field: %s [%s]", ((Term)ontology.getTermMap().get(tid)).getName(), tid.getValue()));
            }
            catch (PhenolRuntimeException e) {
                throw new HpoAnnotationModelException(String.format("Malformed modifier term id: \"%s\"", a));
            }
        }
    }

    private static void checkPublication(String pub) throws HpoAnnotationModelException {
        if (pub == null || pub.isEmpty()) {
            throw new HpoAnnotationModelException("Empty citation string");
        }
        int index = pub.indexOf(":");
        if (index <= 0) {
            throw new HpoAnnotationModelException(String.format("Malformed citation id (not a CURIE): \"%s\"", pub));
        }
        if (pub.contains("::")) {
            throw new HpoAnnotationModelException(String.format("Malformed citation id (double colon): \"%s\"", pub));
        }
        if (pub.contains(" ")) {
            throw new HpoAnnotationModelException(String.format("Malformed citation id (contains space): \"%s\"", pub));
        }
        String prefix = pub.substring(0, index);
        if (!VALID_CITATION_PREFIXES.contains(prefix)) {
            throw new HpoAnnotationModelException(String.format("Did not recognize publication prefix: \"%s\" ", pub));
        }
        int len = pub.length();
        if (len - index < 2) {
            throw new HpoAnnotationModelException(String.format("Malformed publication string: \"%s\" ", pub));
        }
    }

    private static void checkBiocuration(String entrylist) throws HpoAnnotationModelException {
        String[] fields;
        if (entrylist == null || entrylist.isEmpty()) {
            throw new HpoAnnotationModelException("empty biocuration entry");
        }
        for (String f : fields = entrylist.split(";")) {
            Matcher matcher = biocurationPattern.matcher(f);
            if (matcher.find()) continue;
            throw new HpoAnnotationModelException(String.format("Malformed biocuration entry: \"%s\"", f));
        }
    }

    private String getAspect(TermId tid, Ontology ontology) throws HpoAnnotationModelException {
        Term term = (Term)ontology.getTermMap().get(tid);
        if (term == null) {
            throw new HpoAnnotationModelException("Cannot compute Aspect of NULL term");
        }
        TermId primaryTid = term.id();
        if (OntologyAlgorithm.existsPath((MinimalOntology)ontology, (TermId)primaryTid, (TermId)HpoSubOntologyRootTermIds.PHENOTYPIC_ABNORMALITY)) {
            return "P";
        }
        if (OntologyAlgorithm.existsPath((MinimalOntology)ontology, (TermId)primaryTid, (TermId)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT)) {
            return "I";
        }
        if (OntologyAlgorithm.existsPath((MinimalOntology)ontology, (TermId)primaryTid, (TermId)HpoClinicalModifierTermIds.CLINICAL_COURSE)) {
            return "C";
        }
        if (OntologyAlgorithm.existsPath((MinimalOntology)ontology, (TermId)primaryTid, (TermId)HpoSubOntologyRootTermIds.CLINICAL_MODIFIER)) {
            return "M";
        }
        if (primaryTid.equals((Object)HpoSubOntologyRootTermIds.PHENOTYPIC_ABNORMALITY)) {
            return "P";
        }
        if (primaryTid.equals((Object)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT)) {
            return "I";
        }
        throw new HpoAnnotationModelException("Could not determine aspect of TermId " + tid.getValue());
    }

    public String toBigFileLine(Ontology ontology) throws HpoAnnotationModelException {
        CharSequence[] elems = new String[]{this.getDiseaseID(), this.getDiseaseName(), this.getNegation(), this.getPhenotypeId().getValue(), this.getPublication(), this.getEvidenceCode(), this.getAgeOfOnsetId() != null ? this.getAgeOfOnsetId() : EMPTY_STRING, this.getFrequencyModifier() != null ? this.getFrequencyModifier() : EMPTY_STRING, this.getSex(), this.getModifier(), this.getAspect(this.getPhenotypeId(), ontology), this.getBiocuration()};
        return String.join((CharSequence)"\t", elems);
    }
}

