/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo.annotation_impl;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.annotation_impl.RatioAndTemporalIntervalAware;
import org.monarchinitiative.phenol.annotations.formats.hpo.annotation_impl.TemporalRatios;

class TemporalRatiosNaive
implements TemporalRatios {
    private final Ratio ratio;
    private final TemporalInterval temporalInterval;
    private final Iterable<? extends RatioAndTemporalIntervalAware> ratios;

    static TemporalRatiosNaive of(Collection<? extends RatioAndTemporalIntervalAware> ratios) {
        if (ratios.isEmpty()) {
            throw new IllegalArgumentException("Ratios must not be empty");
        }
        int numerator = 0;
        int denominator = 0;
        PointInTime start = null;
        PointInTime end = null;
        for (RatioAndTemporalIntervalAware ratioAndTemporalIntervalAware : ratios) {
            Ratio r = ratioAndTemporalIntervalAware.ratio();
            numerator += r.numerator();
            denominator += r.denominator();
            if (!r.isPositive()) continue;
            PointInTime queryStart = ratioAndTemporalIntervalAware.temporalInterval().map(TemporalInterval::start).orElse(null);
            start = start == null ? queryStart : TemporalRatiosNaive.getEarlierPointInTime(queryStart, start);
            PointInTime queryEnd = ratioAndTemporalIntervalAware.temporalInterval().map(TemporalInterval::end).orElse(null);
            end = end == null ? queryEnd : TemporalRatiosNaive.getLaterPointInTime(queryEnd, end);
        }
        Ratio ratio = Ratio.of(numerator, denominator);
        TemporalInterval temporalInterval = start != null && end != null ? TemporalInterval.of(start, end) : null;
        return new TemporalRatiosNaive(ratio, temporalInterval, ratios);
    }

    private TemporalRatiosNaive(Ratio ratio, TemporalInterval temporalInterval, Iterable<? extends RatioAndTemporalIntervalAware> ratios) {
        this.ratio = Objects.requireNonNull(ratio);
        this.temporalInterval = temporalInterval;
        this.ratios = ratios;
    }

    @Override
    public Ratio ratio() {
        return this.ratio;
    }

    @Override
    public Optional<TemporalInterval> temporalInterval() {
        return Optional.ofNullable(this.temporalInterval);
    }

    @Override
    public int observedInInterval(TemporalInterval query) {
        if (this.temporalInterval != null && !query.overlapsWith(this.temporalInterval)) {
            return 0;
        }
        int numerator = 0;
        for (RatioAndTemporalIntervalAware ratioAndTemporalIntervalAware : this.ratios) {
            if (!ratioAndTemporalIntervalAware.temporalInterval().filter(query::overlapsWith).isPresent()) continue;
            numerator += ratioAndTemporalIntervalAware.ratio().numerator();
        }
        return numerator;
    }

    private static PointInTime getLaterPointInTime(PointInTime query, PointInTime end) {
        return query != null ? PointInTime.max(query, end) : end;
    }

    private static PointInTime getEarlierPointInTime(PointInTime query, PointInTime start) {
        return query == null ? start : PointInTime.min(query, start);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalRatiosNaive that = (TemporalRatiosNaive)o;
        return Objects.equals(this.ratio, that.ratio) && Objects.equals(this.temporalInterval, that.temporalInterval) && Objects.equals(this.ratios, that.ratios);
    }

    public int hashCode() {
        return Objects.hash(this.ratio, this.temporalInterval, this.ratios);
    }

    public String toString() {
        return "TemporalRatiosNaive{ratio=" + String.valueOf(this.ratio) + ", temporalInterval=" + String.valueOf(this.temporalInterval) + ", ratios=" + String.valueOf(this.ratios) + "}";
    }
}

