/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationDataBuilder;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationDataDefault;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotations;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoAssociationData {
    public static HpoAssociationData of(GeneIdentifiers geneIdentifiers, HpoGeneAnnotations hpoGeneAnnotations, DiseaseToGeneAssociations associations) {
        return new HpoAssociationDataDefault(geneIdentifiers, hpoGeneAnnotations, associations);
    }

    public static HpoAssociationDataBuilder builder(MinimalOntology hpo) {
        return new HpoAssociationDataBuilder(hpo);
    }

    public GeneIdentifiers getGeneIdentifiers();

    public HpoGeneAnnotations hpoToGeneAnnotations();

    public DiseaseToGeneAssociations associations();

    default public Map<TermId, String> geneIdToSymbol() {
        return this.geneIdentifiers().stream().collect(Collectors.toUnmodifiableMap(Identified::id, GeneIdentifier::symbol));
    }

    default public Map<TermId, DiseaseToGeneAssociation> associationsByDiseaseId() {
        return this.associations().diseaseToGeneAssociations().collect(Collectors.toUnmodifiableMap(DiseaseToGeneAssociation::diseaseId, Function.identity()));
    }

    @Deprecated(forRemoval=true)
    public static HpoAssociationData of(List<GeneIdentifier> geneIdentifiers, Map<TermId, Collection<GeneIdentifier>> diseaseToGenes, Map<TermId, Collection<TermId>> geneToDiseases, List<HpoGeneAnnotation> hpoGeneAnnotations, DiseaseToGeneAssociations associations) {
        return HpoAssociationData.of(GeneIdentifiers.of(geneIdentifiers), hpoGeneAnnotations, associations);
    }

    @Deprecated(forRemoval=true)
    public static HpoAssociationData of(GeneIdentifiers geneIdentifiers, List<HpoGeneAnnotation> hpoGeneAnnotations, DiseaseToGeneAssociations associations) {
        return HpoAssociationData.of(geneIdentifiers, HpoGeneAnnotations.of(hpoGeneAnnotations), associations);
    }

    @Deprecated(forRemoval=true)
    default public List<GeneIdentifier> geneIdentifiers() {
        return this.getGeneIdentifiers().geneIdentifiers();
    }

    @Deprecated(forRemoval=true)
    default public Map<TermId, Collection<GeneIdentifier>> diseaseToGenes() {
        return this.associations().diseaseIdToGeneIds();
    }

    @Deprecated(forRemoval=true)
    default public Map<TermId, Collection<TermId>> geneToDiseases() {
        return this.associations().geneIdToDiseaseIds();
    }

    @Deprecated(forRemoval=true)
    default public List<HpoGeneAnnotation> phenotypeToGene() {
        return this.hpoToGeneAnnotations().stream().collect(Collectors.toList());
    }
}

