/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.ConfidenceRange;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.PointsInTime;

class Ages {
    static final Age START = new AgeOpen(Integer.MIN_VALUE, true);
    static final Age END = new AgeOpen(Integer.MAX_VALUE, false);
    static final Age LMP = new AgeGestational.AgeGestationalPrecise(0);
    static final Age BIRTH = new AgePostnatal.AgePostnatalPrecise(0);

    Ages() {
    }

    static Age gestational(int days, ConfidenceRange cr) {
        if (cr.isPrecise()) {
            return days == 0 ? LMP : new AgeGestational.AgeGestationalPrecise(days);
        }
        return new AgeGestational.AgeGestationalImprecise(days, cr);
    }

    static Age postnatal(int days, ConfidenceRange ci) {
        if (ci.isPrecise()) {
            return days == 0 ? BIRTH : new AgePostnatal.AgePostnatalPrecise(days);
        }
        return new AgePostnatal.AgePostnatalImprecise(days, ci);
    }

    static class AgeOpen
    implements Age {
        private final int days;
        private final boolean isGestational;

        AgeOpen(int days, boolean isGestational) {
            this.days = days;
            this.isGestational = isGestational;
        }

        @Override
        public int days() {
            return this.days;
        }

        @Override
        public boolean isGestational() {
            return this.isGestational;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public ConfidenceRange confidenceRange() {
            return ConfidenceRange.precise();
        }

        @Override
        public PointInTime start() {
            return PointsInTime.OPEN_START;
        }

        @Override
        public PointInTime end() {
            return PointsInTime.OPEN_END;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AgeOpen ageOpen = (AgeOpen)o;
            return this.days == ageOpen.days && this.isGestational == ageOpen.isGestational;
        }

        public int hashCode() {
            return Objects.hash(this.days, this.isGestational);
        }

        public String toString() {
            return "AgeOpen{days=" + this.days + ", isGestational=" + this.isGestational + "}";
        }
    }

    static class AgePostnatal {
        AgePostnatal() {
        }

        private static class AgePostnatalImprecise
        extends AgePostnatalBase {
            private final ConfidenceRange cr;

            private AgePostnatalImprecise(int days, ConfidenceRange cr) {
                super(days);
                this.cr = cr;
            }

            @Override
            public PointInTime start() {
                return PointInTime.of(this.days + this.cr.lowerBound(), this.isGestational());
            }

            @Override
            public PointInTime end() {
                return PointInTime.of(this.days + this.cr.upperBound(), this.isGestational());
            }

            @Override
            public ConfidenceRange confidenceRange() {
                return this.cr;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                AgePostnatalImprecise that = (AgePostnatalImprecise)o;
                return Objects.equals(this.cr, that.cr);
            }

            @Override
            public int hashCode() {
                return Objects.hash(super.hashCode(), this.cr);
            }

            public String toString() {
                return "AgePostnatalImprecise{days=" + this.days + "cr=" + String.valueOf(this.cr) + "}";
            }
        }

        private static class AgePostnatalPrecise
        extends AgePostnatalBase {
            private AgePostnatalPrecise(int days) {
                super(days);
            }

            @Override
            public PointInTime start() {
                return PointInTime.of(this.days, this.isGestational());
            }

            @Override
            public PointInTime end() {
                return PointInTime.of(this.days, this.isGestational());
            }

            @Override
            public ConfidenceRange confidenceRange() {
                return ConfidenceRange.precise();
            }

            @Override
            public boolean equals(Object o) {
                return super.equals(o);
            }

            @Override
            public int hashCode() {
                return super.hashCode();
            }

            public String toString() {
                return "AgePostnatalPrecise{days=" + this.days + "}";
            }
        }

        private static abstract class AgePostnatalBase
        implements Age {
            protected final int days;

            protected AgePostnatalBase(int days) {
                this.days = days;
            }

            @Override
            public int days() {
                return this.days;
            }

            @Override
            public boolean isGestational() {
                return false;
            }

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public int length() {
                return this.confidenceRange().length();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AgePostnatalBase that = (AgePostnatalBase)o;
                return this.days == that.days;
            }

            public int hashCode() {
                return Objects.hash(this.days);
            }
        }
    }

    static class AgeGestational {
        AgeGestational() {
        }

        private static class AgeGestationalImprecise
        extends AgeGestationalBase {
            private final ConfidenceRange cr;

            private AgeGestationalImprecise(int days, ConfidenceRange cr) {
                super(days);
                this.cr = cr;
            }

            @Override
            public PointInTime start() {
                return PointInTime.of(this.days + this.cr.lowerBound(), this.isGestational());
            }

            @Override
            public PointInTime end() {
                return PointInTime.of(this.days + this.cr.upperBound(), this.isGestational());
            }

            @Override
            public ConfidenceRange confidenceRange() {
                return this.cr;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                AgeGestationalImprecise that = (AgeGestationalImprecise)o;
                return Objects.equals(this.cr, that.cr);
            }

            @Override
            public int hashCode() {
                return Objects.hash(super.hashCode(), this.cr);
            }

            public String toString() {
                return "AgeGestationalImprecise{days=" + this.days + "cr=" + String.valueOf(this.cr) + "}";
            }
        }

        private static class AgeGestationalPrecise
        extends AgeGestationalBase {
            private AgeGestationalPrecise(int days) {
                super(days);
            }

            @Override
            public PointInTime start() {
                return PointInTime.of(this.days, this.isGestational());
            }

            @Override
            public PointInTime end() {
                return PointInTime.of(this.days, this.isGestational());
            }

            @Override
            public ConfidenceRange confidenceRange() {
                return ConfidenceRange.precise();
            }

            public String toString() {
                return "AgeGestationalPrecise{days=" + this.days + "}";
            }
        }

        private static abstract class AgeGestationalBase
        implements Age {
            protected final int days;

            protected AgeGestationalBase(int days) {
                this.days = days;
            }

            @Override
            public int days() {
                return this.days;
            }

            @Override
            public boolean isGestational() {
                return true;
            }

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public int length() {
                return this.confidenceRange().length();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AgeGestationalBase ageDays = (AgeGestationalBase)o;
                return this.days == ageDays.days;
            }

            public int hashCode() {
                return Objects.hash(this.days);
            }
        }
    }
}

