/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.assoc.FileUtils;
import org.monarchinitiative.phenol.annotations.assoc.GeneIdentifierLoader;
import org.monarchinitiative.phenol.annotations.assoc.GeneInfoGeneType;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HumanGeneInfoLoader
implements GeneIdentifierLoader {
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";
    private final Set<GeneInfoGeneType> geneTypes;

    static HumanGeneInfoLoader of(Set<GeneInfoGeneType> geneTypes) {
        return new HumanGeneInfoLoader(geneTypes);
    }

    private HumanGeneInfoLoader(Set<GeneInfoGeneType> geneTypes) {
        this.geneTypes = Objects.requireNonNull(geneTypes);
        if (geneTypes.isEmpty()) {
            throw new IllegalArgumentException("Gene types must not be empty!");
        }
    }

    @Override
    public GeneIdentifiers load(Reader reader) throws IOException {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        List<GeneIdentifier> identifiers = br.lines().filter(line -> !line.startsWith("#")).map(l -> l.split("\t")).filter(HumanGeneInfoLoader.retainSelected(this.geneTypes)).map(HumanGeneInfoLoader.toGeneIdentifier()).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return GeneIdentifiers.of(identifiers);
    }

    @Deprecated(forRemoval=true)
    public static GeneIdentifiers loadGeneIdentifiers(Path geneInfoFile, Set<GeneInfoGeneType> geneTypes) throws IOException {
        try (InputStream is = FileUtils.newInputStream(geneInfoFile);){
            GeneIdentifiers geneIdentifiers = HumanGeneInfoLoader.loadGeneIdentifiers(is, geneTypes);
            return geneIdentifiers;
        }
    }

    @Deprecated(forRemoval=true)
    public static GeneIdentifiers loadGeneIdentifiers(InputStream is, Set<GeneInfoGeneType> geneTypes) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        List<GeneIdentifier> identifiers = reader.lines().filter(line -> !line.startsWith("#")).map(l -> l.split("\t")).filter(HumanGeneInfoLoader.retainSelected(geneTypes)).map(HumanGeneInfoLoader.toGeneIdentifier()).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return GeneIdentifiers.of(identifiers);
    }

    private static Predicate<? super String[]> retainSelected(Set<GeneInfoGeneType> geneTypes) {
        return tokens -> geneTypes.contains((Object)GeneInfoGeneType.parse(tokens[9]));
    }

    @Deprecated(forRemoval=true, since="v2.0.0-RC3")
    public static GeneIdentifiers loadGeneIdentifiers(Path geneInfoFile) throws IOException {
        return HumanGeneInfoLoader.loadGeneIdentifiers(geneInfoFile, GeneInfoGeneType.ALL);
    }

    private static Function<String[], Optional<GeneIdentifier>> toGeneIdentifier() {
        return tokens -> {
            String taxon = tokens[0];
            if (!taxon.equals("9606")) {
                return Optional.empty();
            }
            String id = tokens[1];
            if (id.equals("122405565")) {
                return Optional.empty();
            }
            String symbol = tokens[2];
            if (symbol.equals("TRNAV-CAC")) {
                return Optional.empty();
            }
            TermId tid = TermId.of((String)ENTREZ_GENE_PREFIX, (String)id);
            return Optional.of(GeneIdentifier.of(tid, symbol));
        };
    }
}

