/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

class Utils {
    private Utils() {
    }

    static <T> Iterable<T> filterIterable(final Iterable<T> parent, final Predicate<T> filter) {
        return new Iterable<T>(){
            private final Iterable<T> iterable;
            {
                this.iterable = Objects.requireNonNull(parent);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<T> iterator;
                    private T next;
                    {
                        this.iterator = iterable.iterator();
                        this.next = this.nextPassingElement();
                    }

                    private T nextPassingElement() {
                        while (this.iterator.hasNext()) {
                            Object t = this.iterator.next();
                            if (!filter.test(t)) continue;
                            return t;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object current = this.next;
                        this.next = this.nextPassingElement();
                        return current;
                    }
                };
            }
        };
    }
}

