/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class DiseaseToGeneAssociation {
    private final TermId diseaseId;
    private final List<GeneToAssociation> geneToAssociations;

    public static DiseaseToGeneAssociation of(TermId diseaseId, List<GeneToAssociation> geneToAssociations) {
        return new DiseaseToGeneAssociation(diseaseId, geneToAssociations);
    }

    private DiseaseToGeneAssociation(TermId diseaseId, List<GeneToAssociation> geneAssociations) {
        this.diseaseId = Objects.requireNonNull(diseaseId, "Disease id must not be null");
        this.geneToAssociations = Objects.requireNonNull(geneAssociations, "Gene associations must not be null");
    }

    public TermId diseaseId() {
        return this.diseaseId;
    }

    public List<GeneToAssociation> associations() {
        return this.geneToAssociations;
    }

    public List<GeneIdentifier> geneIdentifiers() {
        return this.geneToAssociations.stream().map(GeneToAssociation::geneIdentifier).distinct().collect(Collectors.toUnmodifiableList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiseaseToGeneAssociation that = (DiseaseToGeneAssociation)o;
        return Objects.equals(this.diseaseId, that.diseaseId) && Objects.equals(this.geneToAssociations, that.geneToAssociations);
    }

    public int hashCode() {
        return Objects.hash(this.diseaseId, this.geneToAssociations);
    }

    public String toString() {
        return "DiseaseToGeneAssociation{disease=" + String.valueOf(this.diseaseId) + ", gene2assoc=" + String.valueOf(this.geneToAssociations) + "}";
    }
}

