/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats;

import java.util.Objects;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GeneIdentifier
implements Identified {
    private final TermId id;
    private final String symbol;

    public static GeneIdentifier of(TermId termId, String geneSymbol) {
        return new GeneIdentifier(termId, geneSymbol);
    }

    private GeneIdentifier(TermId tid, String geneSymbol) {
        this.id = Objects.requireNonNull(tid, "Term ID must not be null");
        this.symbol = Objects.requireNonNull(geneSymbol, "Gene symbol must not be null");
    }

    public TermId id() {
        return this.id;
    }

    public String symbol() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneIdentifier geneIdentifier = (GeneIdentifier)o;
        return Objects.equals(this.id, geneIdentifier.id) && Objects.equals(this.symbol, geneIdentifier.symbol);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.symbol);
    }

    public String toString() {
        return this.symbol + " [" + this.id.getValue() + "]";
    }
}

