/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.PointsInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;

class TemporalIntervals {
    static final TemporalInterval BIRTH = TemporalInterval.of(PointsInTime.BIRTH, PointsInTime.BIRTH);
    static final TemporalInterval GESTATIONAL_PERIOD = TemporalInterval.of(PointInTime.lastMenstrualPeriod(), PointInTime.birth());
    static final TemporalInterval POSTNATAL_PERIOD = TemporalInterval.of(PointInTime.birth(), PointInTime.openEnd());
    static final TemporalInterval OPEN = new OpenTemporalInterval();

    static TemporalInterval of(PointInTime start, PointInTime end) {
        if (start.isOpen() || end.isOpen()) {
            if (start.isOpen()) {
                return new TemporalIntervalWithOpenStart(end);
            }
            if (end.isOpen()) {
                return new TemporalIntervalWithOpenEnd(start);
            }
            return OPEN;
        }
        return new DefaultTemporalInterval(start, end);
    }

    private TemporalIntervals() {
    }

    static class TemporalIntervalWithOpenStart
    implements TemporalInterval {
        private final PointInTime end;

        TemporalIntervalWithOpenStart(PointInTime end) {
            this.end = Objects.requireNonNull(end);
        }

        @Override
        public PointInTime start() {
            return PointsInTime.OPEN_START;
        }

        @Override
        public PointInTime end() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporalIntervalWithOpenStart that = (TemporalIntervalWithOpenStart)o;
            return Objects.equals(this.end, that.end);
        }

        public int hashCode() {
            return Objects.hash(this.start(), this.end);
        }

        public String toString() {
            return "TemporalIntervalWithOpenStart{end=" + String.valueOf(this.end) + "}";
        }
    }

    static class TemporalIntervalWithOpenEnd
    implements TemporalInterval {
        private final PointInTime start;

        TemporalIntervalWithOpenEnd(PointInTime start) {
            this.start = Objects.requireNonNull(start);
        }

        @Override
        public PointInTime start() {
            return this.start;
        }

        @Override
        public PointInTime end() {
            return PointsInTime.OPEN_END;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporalIntervalWithOpenEnd that = (TemporalIntervalWithOpenEnd)o;
            return Objects.equals(this.start, that.start);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end());
        }

        public String toString() {
            return "TemporalIntervalWithOpenEnd{start=" + String.valueOf(this.start) + "}";
        }
    }

    static class DefaultTemporalInterval
    implements TemporalInterval {
        private final PointInTime start;
        private final PointInTime end;

        private DefaultTemporalInterval(PointInTime start, PointInTime end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public PointInTime start() {
            return this.start;
        }

        @Override
        public PointInTime end() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultTemporalInterval that = (DefaultTemporalInterval)o;
            return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return "DefaultTemporalInterval{start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
        }
    }

    static class OpenTemporalInterval
    implements TemporalInterval {
        private OpenTemporalInterval() {
        }

        @Override
        public PointInTime start() {
            return PointsInTime.OPEN_START;
        }

        @Override
        public PointInTime end() {
            return PointsInTime.OPEN_END;
        }

        public String toString() {
            return "OpenTemporalInterval";
        }
    }
}

