/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import org.monarchinitiative.phenol.annotations.base.temporal.PointsInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TimelineAware;
import org.monarchinitiative.phenol.annotations.base.temporal.Util;

public interface PointInTime
extends TimelineAware {
    public static final int MAX_YEARS = 2000;
    public static final int MAX_DAYS = 730500;

    public static PointInTime lastMenstrualPeriod() {
        return PointsInTime.LMP;
    }

    public static PointInTime birth() {
        return PointsInTime.BIRTH;
    }

    public static PointInTime of(int days, boolean isGestational) {
        return PointsInTime.of(Util.checkDays(days), isGestational);
    }

    public static PointInTime openStart() {
        return PointsInTime.OPEN_START;
    }

    public static PointInTime openEnd() {
        return PointsInTime.OPEN_END;
    }

    public int days();

    public boolean isOpen();

    default public int completeWeeks() {
        return this.days() / 7;
    }

    default public int completeMonths() {
        return (int)((float)this.days() / 30.4375f);
    }

    default public int completeYears() {
        return (int)((float)this.days() / 365.25f);
    }

    default public boolean isClosed() {
        return !this.isOpen();
    }

    default public boolean isZero() {
        return this.days() == 0;
    }

    default public boolean isPositive() {
        return this.days() > 0;
    }

    default public boolean isBefore(PointInTime other) {
        return PointInTime.compare(this, other) < 0;
    }

    default public boolean isAtOrBefore(PointInTime other) {
        return PointInTime.compare(this, other) <= 0;
    }

    default public boolean isAfter(PointInTime other) {
        return !this.isAtOrBefore(other);
    }

    default public boolean isAtOrAfter(PointInTime other) {
        return !this.isBefore(other);
    }

    default public boolean isAt(PointInTime other) {
        return PointInTime.compare(this, other) == 0;
    }

    public static PointInTime max(PointInTime a, PointInTime b) {
        int compare = PointInTime.compare(a, b);
        return compare >= 0 ? a : b;
    }

    public static PointInTime min(PointInTime a, PointInTime b) {
        int compare = PointInTime.compare(a, b);
        return compare <= 0 ? a : b;
    }

    public static int compare(PointInTime x, PointInTime y) {
        if (x.isGestational() ^ y.isGestational()) {
            return x.isGestational() ? -1 : 1;
        }
        return Integer.compare(x.days(), y.days());
    }
}

