/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.monarchinitiative.phenol.annotations.assoc.FileUtils;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.annotations.formats.hpo.AssociationType;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class Mim2GeneMedgenLoader {
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";
    private static final String OMIM_PREFIX = "OMIM";

    public static DiseaseToGeneAssociations loadDiseaseToGeneAssociations(Path mim2geneMedgene, GeneIdentifiers geneIdentifiers) throws IOException {
        HashMap<TermId, Collection> associationMap = new HashMap<TermId, Collection>();
        try (BufferedReader br = FileUtils.newBufferedReader(mim2geneMedgene);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] associations;
                if (line.startsWith("#") || !(associations = line.split("\t"))[2].equals("phenotype")) continue;
                String mimid = associations[0];
                TermId omimCurie = TermId.of((String)OMIM_PREFIX, (String)mimid);
                String entrezGeneNumber = associations[1];
                if ("-".equals(entrezGeneNumber)) continue;
                TermId entrezId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                String symbol = geneIdentifiers.geneIdById(entrezId).map(GeneIdentifier::symbol).orElse("-");
                TermId geneId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                GeneIdentifier geneIdentifier = GeneIdentifier.of(geneId, symbol);
                AssociationType associationType = associations[5].contains("susceptibility") ? AssociationType.POLYGENIC : AssociationType.MENDELIAN;
                GeneToAssociation g2a = GeneToAssociation.of(geneIdentifier, associationType);
                associationMap.computeIfAbsent(omimCurie, k -> new HashSet()).add(g2a);
            }
            ArrayList diseaseToGeneAssociations = new ArrayList(associationMap.size());
            associationMap.forEach((k, v) -> diseaseToGeneAssociations.add(DiseaseToGeneAssociation.of(k, List.copyOf(v))));
            DiseaseToGeneAssociations diseaseToGeneAssociations2 = DiseaseToGeneAssociations.of(Collections.unmodifiableList(diseaseToGeneAssociations));
            return diseaseToGeneAssociations2;
        }
    }
}

