/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GeneInfoGeneType {
    protein_coding,
    pseudo,
    biological_region,
    snoRNA,
    snRNA,
    scRNA,
    rRNA,
    tRNA,
    ncRNA,
    other,
    unknown;

    private static final Logger LOGGER;
    public static final Set<GeneInfoGeneType> ALL;
    public static final Set<GeneInfoGeneType> DEFAULT;

    public static GeneInfoGeneType parse(String value) {
        switch (value.toLowerCase()) {
            case "protein-coding": {
                return protein_coding;
            }
            case "ncrna": {
                return ncRNA;
            }
            case "pseudo": {
                return pseudo;
            }
            case "biological-region": {
                return biological_region;
            }
            case "unknown": {
                return unknown;
            }
            case "snorna": {
                return snoRNA;
            }
            case "other": {
                return other;
            }
            case "rrna": {
                return rRNA;
            }
            case "trna": {
                return tRNA;
            }
            case "snrna": {
                return snRNA;
            }
            case "scrna": {
                return scRNA;
            }
        }
        LOGGER.warn("Unknown gene info gene type '{}', falling back to 'unknown'", (Object)value);
        return unknown;
    }

    static {
        LOGGER = LoggerFactory.getLogger(GeneInfoGeneType.class);
        ALL = EnumSet.allOf(GeneInfoGeneType.class);
        DEFAULT = EnumSet.of(protein_coding, ncRNA, tRNA);
    }
}

