/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseData;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseDataContainer;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseDataLoader;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HpoaDiseaseDataLoaderDefault
implements HpoaDiseaseDataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoaDiseaseDataLoaderDefault.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("#(version|date): (?<version>[\\w-]+)$");
    private static final Pattern HPO_VERSION_PATTERN = Pattern.compile("#hpo-version: .*/(?<hpoversion>[^/]+)/hp\\.(json|obo\\.owl|obo|owl)$", 2);
    private final Set<DiseaseDatabase> databasePrefixes;

    HpoaDiseaseDataLoaderDefault(Set<DiseaseDatabase> prefixes) {
        this.databasePrefixes = Objects.requireNonNull(prefixes);
    }

    @Override
    public HpoaDiseaseDataContainer loadDiseaseData(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        HashMap<TermId, List> annotationLinesByDiseaseId = new HashMap<TermId, List>();
        boolean finishedParsingHeader = false;
        String version = null;
        String hpoVersion = null;
        String line = reader.readLine();
        while (line != null) {
            block16: {
                if (line.startsWith("#")) {
                    Matcher matcher;
                    if (line.startsWith("#version:") || line.startsWith("#date:")) {
                        matcher = VERSION_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            version = matcher.group("version");
                            LOGGER.debug("Detected HPO annotations version {}", (Object)version);
                        } else {
                            LOGGER.warn("Could not parse HPO annotations version from the line {}", (Object)line);
                        }
                    } else if (line.toLowerCase().startsWith("#hpo-version:")) {
                        matcher = HPO_VERSION_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            hpoVersion = matcher.group("hpoversion");
                            LOGGER.debug("HPO version used to generate the annotations {}", (Object)hpoVersion);
                        } else {
                            LOGGER.warn("Could not determine HPO version from the line {}", (Object)line);
                        }
                    }
                } else if (!finishedParsingHeader && line.startsWith("database_id")) {
                    if (line.split("\t").length != 12) {
                        LOGGER.error("HPOA header column does not have expected column length.");
                        throw new IOException("HPOA header column does not have expected column length.");
                    }
                    finishedParsingHeader = true;
                } else {
                    HpoAnnotationLine annotationLine;
                    try {
                        annotationLine = HpoAnnotationLine.of(line);
                    }
                    catch (PhenolException e) {
                        LOGGER.warn("Error {} while parsing line: {}", (Object)e.getMessage(), (Object)line);
                        break block16;
                    }
                    if (this.databasePrefixes.contains((Object)DiseaseDatabase.fromString(annotationLine.diseaseId().getPrefix()))) {
                        annotationLinesByDiseaseId.computeIfAbsent(annotationLine.diseaseId(), k -> new ArrayList()).add(annotationLine);
                    }
                }
            }
            line = reader.readLine();
        }
        List<HpoaDiseaseData> data = annotationLinesByDiseaseId.entrySet().stream().map(HpoaDiseaseDataLoaderDefault.processAnnotationEntry()).collect(Collectors.toList());
        return new HpoaDiseaseDataContainer(version, hpoVersion, data);
    }

    private static Function<Map.Entry<TermId, List<HpoAnnotationLine>>, HpoaDiseaseData> processAnnotationEntry() {
        return e -> {
            String diseaseName = ((HpoAnnotationLine)((List)e.getValue()).get(0)).diseaseName();
            return new HpoaDiseaseData((TermId)e.getKey(), diseaseName, (List)e.getValue());
        };
    }
}

