/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.Objects;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;

public class HpoDiseaseLoaderOptions {
    public static final Set<DiseaseDatabase> DATABASE_PREFIXES = Set.of(DiseaseDatabase.OMIM, DiseaseDatabase.ORPHANET, DiseaseDatabase.DECIPHER);
    public static final int DEFAULT_COHORT_SIZE = 5;
    private final Set<DiseaseDatabase> includedDatabases;
    private final boolean salvageNegatedFrequencies;
    private final int cohortSize;

    public static HpoDiseaseLoaderOptions defaultOptions() {
        return HpoDiseaseLoaderOptions.of(DATABASE_PREFIXES, true, 5);
    }

    public static HpoDiseaseLoaderOptions defaultOmim() {
        return HpoDiseaseLoaderOptions.of(Set.of(DiseaseDatabase.OMIM));
    }

    public static HpoDiseaseLoaderOptions of(Set<DiseaseDatabase> databasePrefixes) {
        return HpoDiseaseLoaderOptions.of(databasePrefixes, true, 5);
    }

    public static HpoDiseaseLoaderOptions of(Set<DiseaseDatabase> databasePrefixes, boolean salvageNegatedFrequencies, int cohortSize) {
        return new HpoDiseaseLoaderOptions(databasePrefixes, salvageNegatedFrequencies, cohortSize);
    }

    private HpoDiseaseLoaderOptions(Set<DiseaseDatabase> includedDatabases, boolean salvageNegatedFrequencies, int cohortSize) {
        this.includedDatabases = Objects.requireNonNull(includedDatabases, "Database prefixes must not be null");
        this.salvageNegatedFrequencies = salvageNegatedFrequencies;
        if (cohortSize <= 0) {
            throw new IllegalArgumentException("Cohort size must be positive");
        }
        this.cohortSize = cohortSize;
    }

    public Set<DiseaseDatabase> includedDatabases() {
        return this.includedDatabases;
    }

    public boolean salvageNegatedFrequencies() {
        return this.salvageNegatedFrequencies;
    }

    public int cohortSize() {
        return this.cohortSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoDiseaseLoaderOptions options = (HpoDiseaseLoaderOptions)o;
        return this.salvageNegatedFrequencies == options.salvageNegatedFrequencies && this.cohortSize == options.cohortSize && Objects.equals(this.includedDatabases, options.includedDatabases);
    }

    public int hashCode() {
        return Objects.hash(this.includedDatabases, this.salvageNegatedFrequencies, this.cohortSize);
    }

    public String toString() {
        return "HpoDiseaseLoaderOptions{includedDatabases=" + String.valueOf(this.includedDatabases) + ", salvageNegatedFrequencies=" + this.salvageNegatedFrequencies + ", cohortSize=" + this.cohortSize + "}";
    }
}

