/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.mpo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpAnnotation;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpModel;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpModifier;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpSimpleModel;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpGeneModel
extends MpModel {
    private static final Logger logger = LoggerFactory.getLogger(MpGeneModel.class);
    private List<TermId> genotypes;

    public MpGeneModel(TermId markerId, List<MpSimpleModel> modelList) {
        this.init(markerId, modelList.toArray(new MpSimpleModel[0]));
    }

    private void init(TermId markerId, MpSimpleModel[] models) {
        this.markerId = markerId;
        this.mergeGenotypesAndPhenotypes(models);
    }

    private void mergeGenotypesAndPhenotypes(MpSimpleModel[] models) {
        HashMap annotsByMpId = new HashMap();
        ArrayList<TermId> genotypesBuilder = new ArrayList<TermId>(models.length);
        for (MpSimpleModel model : models) {
            genotypesBuilder.add(model.getGenotypeId());
            for (MpAnnotation annot : model.getPhenotypicAbnormalities()) {
                TermId mpId = annot.getTermId();
                annotsByMpId.putIfAbsent(mpId, new HashSet());
                ((Set)annotsByMpId.get(mpId)).add(annot);
            }
        }
        ArrayList<MpAnnotation> listbuilder = new ArrayList<MpAnnotation>(annotsByMpId.size());
        for (TermId tid : annotsByMpId.keySet()) {
            HashSet<String> pmids = new HashSet<String>();
            HashSet<MpModifier> modifierSet = new HashSet<MpModifier>();
            Set setOfMap = (Set)annotsByMpId.get(tid);
            for (MpAnnotation map : setOfMap) {
                pmids.addAll(map.getPmidSet());
                modifierSet.addAll(map.getModifiers());
            }
            MpAnnotation mpa = new MpAnnotation.Builder(tid, pmids).modifiers(modifierSet).build();
            listbuilder.add(mpa);
        }
        this.phenotypicAbnormalities = Collections.unmodifiableList(listbuilder);
        this.genotypes = Collections.unmodifiableList(genotypesBuilder);
    }

    static List<MpGeneModel> createGeneModelList(List<MpSimpleModel> simpleModelList) {
        HashMap<TermId, List> modelsByGene = new HashMap<TermId, List>();
        for (MpSimpleModel model : simpleModelList) {
            TermId geneticMarker = model.getMarkerId();
            modelsByGene.putIfAbsent(geneticMarker, new ArrayList());
            List matchingModels = (List)modelsByGene.get(geneticMarker);
            matchingModels.add(model);
        }
        ArrayList returnListBuilder = new ArrayList(modelsByGene.size());
        modelsByGene.forEach((k, v) -> returnListBuilder.add(new MpGeneModel((TermId)k, (List<MpSimpleModel>)v)));
        return Collections.unmodifiableList(returnListBuilder);
    }

    public List<TermId> getGenotypes() {
        return this.genotypes;
    }

    public int getGenotypesCount() {
        return this.genotypes.size();
    }
}

