/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo.annotation_impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationRecord;
import org.monarchinitiative.phenol.annotations.formats.hpo.annotation_impl.TemporalRatios;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoDiseaseAnnotationRecordBacked
implements HpoDiseaseAnnotation {
    private final TermId id;
    private final Iterable<HpoDiseaseAnnotationRecord> records;
    private final TemporalRatios temporalRatios;

    public static HpoDiseaseAnnotationRecordBacked of(TermId id, Collection<HpoDiseaseAnnotationRecord> records) {
        TemporalRatios ratios = TemporalRatios.of(records);
        return new HpoDiseaseAnnotationRecordBacked(id, ratios, records);
    }

    private HpoDiseaseAnnotationRecordBacked(TermId id, TemporalRatios ratios, Collection<HpoDiseaseAnnotationRecord> records) {
        this.id = Objects.requireNonNull(id);
        this.temporalRatios = ratios;
        this.records = Objects.requireNonNull(records);
    }

    public TermId id() {
        return this.id;
    }

    @Override
    public Ratio ratio() {
        return this.temporalRatios.ratio();
    }

    @Override
    public Optional<PointInTime> earliestOnset() {
        return this.temporalRatios.start();
    }

    @Override
    public Optional<PointInTime> latestOnset() {
        return HpoDiseaseAnnotationRecordBacked.findEndpoint(this.records, TemporalInterval::start, PointInTime::max);
    }

    @Override
    public Optional<PointInTime> earliestResolution() {
        return HpoDiseaseAnnotationRecordBacked.findEndpoint(this.records, TemporalInterval::end, PointInTime::min);
    }

    @Override
    public Optional<PointInTime> latestResolution() {
        return this.temporalRatios.end();
    }

    @Override
    public int observedInInterval(TemporalInterval query) {
        return this.temporalRatios.observedInInterval(query);
    }

    private Stream<HpoDiseaseAnnotationRecord> records() {
        return StreamSupport.stream(this.records.spliterator(), false);
    }

    @Override
    public List<TermId> modifiers() {
        return this.records().flatMap(r -> r.modifiers().stream()).collect(Collectors.toList());
    }

    @Override
    public List<AnnotationReference> references() {
        return this.records().flatMap(r -> r.references().stream()).collect(Collectors.toList());
    }

    private static Optional<PointInTime> findEndpoint(Iterable<HpoDiseaseAnnotationRecord> records, Function<TemporalInterval, PointInTime> endpointExtractor, BiFunction<PointInTime, PointInTime, PointInTime> endpointSelector) {
        PointInTime pit = null;
        for (HpoDiseaseAnnotationRecord record : records) {
            if (!record.isPresent()) continue;
            PointInTime onset = record.temporalInterval().map(endpointExtractor).orElse(null);
            pit = HpoDiseaseAnnotationRecordBacked.selectPointInTime(pit, onset, endpointSelector);
        }
        return Optional.ofNullable(pit);
    }

    private static PointInTime selectPointInTime(PointInTime a, PointInTime b, BiFunction<PointInTime, PointInTime, PointInTime> f) {
        a = a == null ? b : (b == null ? b : f.apply(a, b));
        return a;
    }

    public String toString() {
        return "HpoDiseaseAnnotationRecordBacked{id=" + String.valueOf(this.id) + ", records=" + String.valueOf(this.records) + ", temporalRatios=" + String.valueOf(this.temporalRatios) + "}";
    }
}

