/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class HpoGeneAnnotation
implements TermAnnotation {
    private static final long serialVersionUID = 2L;
    private final int entrezGeneId;
    private final String entrezGeneSymbol;
    private final String hpoTermName;
    private final TermId hpoTermId;

    public HpoGeneAnnotation(int entrezGeneId, String entrezGeneSymbol, TermId hpoTermId, String hpoTermName) {
        this.entrezGeneId = entrezGeneId;
        this.entrezGeneSymbol = entrezGeneSymbol;
        this.hpoTermName = hpoTermName;
        this.hpoTermId = hpoTermId;
    }

    public int getEntrezGeneId() {
        return this.entrezGeneId;
    }

    public String getEntrezGeneSymbol() {
        return this.entrezGeneSymbol;
    }

    public String getTermName() {
        return this.hpoTermName;
    }

    public TermId id() {
        return this.hpoTermId;
    }

    public TermId getItemId() {
        return TermId.of((String)String.format("NCBIGene:%d", this.entrezGeneId));
    }

    public String toString() {
        return "HPOGeneAnnotation [entrezGeneId=" + this.entrezGeneId + ", entrezGeneSymbol=" + this.entrezGeneSymbol + ", termName=" + this.hpoTermName + ", termId=" + String.valueOf(this.hpoTermId) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entrezGeneId;
        result = 31 * result + (this.entrezGeneSymbol == null ? 0 : this.entrezGeneSymbol.hashCode());
        result = 31 * result + (this.hpoTermId == null ? 0 : this.hpoTermId.hashCode());
        result = 31 * result + (this.hpoTermName == null ? 0 : this.hpoTermName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HpoGeneAnnotation other = (HpoGeneAnnotation)obj;
        if (this.entrezGeneId != other.entrezGeneId) {
            return false;
        }
        if (this.entrezGeneSymbol == null ? other.entrezGeneSymbol != null : !this.entrezGeneSymbol.equals(other.entrezGeneSymbol)) {
            return false;
        }
        if (this.hpoTermId == null ? other.hpoTermId != null : !this.hpoTermId.equals((Object)other.hpoTermId)) {
            return false;
        }
        return !(this.hpoTermName == null ? other.hpoTermName != null : !this.hpoTermName.equals(other.hpoTermName));
    }

    public int compareTo(TermAnnotation o) {
        if (!(o instanceof HpoGeneAnnotation)) {
            throw new RuntimeException("Cannot compare " + String.valueOf(o) + " to a HpoGeneAnnotation");
        }
        HpoGeneAnnotation that = (HpoGeneAnnotation)o;
        int result = Integer.compare(this.entrezGeneId, that.entrezGeneId);
        if (result != 0) {
            return result;
        }
        result = this.entrezGeneSymbol.compareTo(that.entrezGeneSymbol);
        if (result != 0) {
            return result;
        }
        result = this.hpoTermName.compareTo(that.hpoTermName);
        if (result != 0) {
            return result;
        }
        return this.hpoTermId.compareTo(that.hpoTermId);
    }
}

